/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadObjectMappingJoinReadingTest
extends AutoVerifyTestCase {
    Employee employee;
    int oldJoinFetch;

    protected void setup() {
        ClassDescriptor descriptor = this.getSession().getDescriptor(Employee.class);
        this.oldJoinFetch = ((OneToOneMapping)descriptor.getMappingForAttributeName("address")).getJoinFetch();
        ((OneToOneMapping)descriptor.getMappingForAttributeName("address")).useInnerJoinFetch();
        descriptor.reInitializeJoinedAttributes();
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSelectionCriteria(descriptor.getObjectBuilder().getPrimaryKeyExpression());
        descriptor.getQueryManager().setReadObjectQuery(readObjectQuery);
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Expression expression = new ExpressionBuilder().get("id").equal((Object)this.employee.getId());
        this.employee = (Employee)uow.readObject(Employee.class, expression);
    }

    protected void verify() {
        Employee original = (Employee)this.getSession().readObject((Object)this.employee);
        if (!original.address.isInstantiated()) {
            throw new TestErrorException("Employee's address was not joined.");
        }
        this.employee.getAddress().getCity();
    }

    public void reset() {
        ClassDescriptor descriptor = this.getSession().getDescriptor(Employee.class);
        ((OneToOneMapping)descriptor.getMappingForAttributeName("address")).setJoinFetch(this.oldJoinFetch);
        descriptor.reInitializeJoinedAttributes();
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSelectionCriteria(descriptor.getObjectBuilder().getPrimaryKeyExpression());
        descriptor.getQueryManager().setReadObjectQuery(readObjectQuery);
    }
}

