/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class OrderingTest
extends TestCase {
    protected Vector customSQLRows;
    protected Vector orderedQueryObjects;

    public OrderingTest() {
        this.setDescription("This test verifies the ordering feature works properly");
    }

    protected void setup() {
        this.customSQLRows = this.getSession().executeSelectingCall((Call)new SQLCall("SELECT * FROM EMPLOYEE ORDER BY L_NAME, F_NAME"));
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(new Employee().getClass());
        query.addAscendingOrdering("lastName");
        query.addAscendingOrdering("firstName");
        this.orderedQueryObjects = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        for (int i = 0; i < this.orderedQueryObjects.size(); ++i) {
            DataRecord row = (DataRecord)this.customSQLRows.elementAt(i);
            Employee employee = (Employee)this.orderedQueryObjects.elementAt(i);
            String firstName = (String)row.get((Object)"F_NAME");
            String lastName = (String)row.get((Object)"L_NAME");
            if (employee.getFirstName().equals(firstName) && employee.getLastName().equals(lastName)) continue;
            throw new TestErrorException("The ordering test failed.  The results are not in the right order");
        }
    }
}

