/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class TimestampDateTest
extends PerformanceComparisonTestCase {
    protected Connection connection;
    protected Number id;
    protected String sql;

    public TimestampDateTest() {
        this.setName("getObject vs getDate DateConversionPerformanceComparisonTest");
        this.setDescription("Compares the performance between accessing timestamps as objects and converting them or directly as dates them.");
        this.addGetDate();
    }

    public void setup() throws Exception {
        this.connection = (Connection)((AbstractSession)this.getSession()).getAccessor().getDatasourceConnection();
        this.sql = "SELECT START_DATE FROM EMPLOYEE";
    }

    public void test() throws Exception {
        PreparedStatement statement = this.connection.prepareStatement(this.sql);
        ResultSet result = statement.executeQuery();
        int size = result.getMetaData().getColumnCount();
        Vector rows = new Vector();
        while (result.next()) {
            Vector<Object> row = new Vector<Object>(size);
            for (int column = 1; column <= size; ++column) {
                Object value = result.getObject(column);
                value = ConversionManager.getDefaultManager().convertObject(value, ClassConstants.SQLDATE);
                row.add(value);
            }
            rows.add(row);
        }
        result.close();
        statement.close();
    }

    public void addGetDate() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() throws Exception {
                PreparedStatement statement = TimestampDateTest.this.connection.prepareStatement(TimestampDateTest.this.sql);
                ResultSet result = statement.executeQuery();
                int size = result.getMetaData().getColumnCount();
                Vector rows = new Vector();
                while (result.next()) {
                    Vector<Object> row = new Vector<Object>(size);
                    for (int column = 1; column <= size; ++column) {
                        Object value = result.getDate(column);
                        value = ConversionManager.getDefaultManager().convertObject(value, ClassConstants.SQLDATE);
                        row.add(value);
                    }
                    rows.add(row);
                }
                result.close();
                statement.close();
            }
        };
        test.setAllowableDecrease(5.0);
        test.setName("GetDateTest");
        this.addTest((TestCase)test);
    }
}

