/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.util.HashMap;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class ComplexMethodTest
extends PerformanceComparisonTestCase {
    protected HashMap map;

    public ComplexMethodTest() {
        this.setName("ComplexMethodExecution vs SynchronizedMethod PerformanceComparisonTest");
        this.setDescription("This test compares the performance for final, synchronized and normal method execution.");
        this.addSynchronizedTest();
        this.addSynchronizedBlockTest();
        this.addFinalTest();
        this.map = new HashMap();
        this.map.put(this, this);
    }

    public void test() throws Exception {
        Object value = this.map.get((Object)this);
        this.map.put(this, value);
    }

    public void addSynchronizedTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public synchronized void test() {
                Object value = ComplexMethodTest.this.map.get((Object)this);
                ComplexMethodTest.this.map.put(this, value);
            }
        };
        test.setName("SynchronizedTest");
        test.setAllowableDecrease(-200.0);
        this.addTest((TestCase)test);
    }

    public void addSynchronizedBlockTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    Object value = ComplexMethodTest.this.map.get((Object)this);
                    ComplexMethodTest.this.map.put(this, value);
                }
            }
        };
        test.setName("SynchronizedBlockTest");
        test.setAllowableDecrease(-200.0);
        this.addTest((TestCase)test);
    }

    public void addFinalTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public final void test() {
                Object value = ComplexMethodTest.this.map.get((Object)this);
                ComplexMethodTest.this.map.put(this, this);
            }
        };
        test.setName("FinalTest");
        this.addTest((TestCase)test);
    }
}

