/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.optimisticlocking.Camera;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsole;
import org.eclipse.persistence.testing.models.optimisticlocking.PowerSupplyUnit;
import org.eclipse.persistence.testing.tests.optimisticlocking.SwitchableOptimisticLockingPolicyTest;

public class UpdateNullOneToOneValueTest
extends SwitchableOptimisticLockingPolicyTest {
    protected GamesConsole original;
    protected GamesConsole original2;

    public UpdateNullOneToOneValueTest(Class<?> optimisticLockingPolicyClass) {
        super(optimisticLockingPolicyClass);
        this.addClassToModify(GamesConsole.class);
        this.addClassToModify(Camera.class);
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = new GamesConsole();
        this.original.setName("PloughStation");
        this.original.setCamera(null);
        this.original.setPsu(new PowerSupplyUnit("0-123-456-789"));
        this.original2 = new GamesConsole();
        this.original2.setName("Nintundo65");
        uow.registerObject((Object)this.original);
        uow.registerObject((Object)this.original2);
        uow.commit();
    }

    public void test() throws TestException {
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.readObjectAndChangeAttributeValue(new Camera("lookcam", "black"));
            this.readObjectAndChangeAttributeValue(null);
            this.readObjectAndChangeAttributeValue(new Camera("barbeye", "pink"));
            this.readObjectAndChangeAttributeValue(new Camera("appleofmyeye", "white"));
            this.readObjectAndChangeAttributeValue(null);
            this.deleteObject(this.original);
            this.deleteObject(this.original2);
        }
        catch (Exception tle) {
            this.tlException = tle;
            this.tlException.printStackTrace();
        }
    }

    public void readObjectAndChangeAttributeValue(Camera newCamera) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        GamesConsole clone = (GamesConsole)uow.readObject(GamesConsole.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullOneToOneValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        clone.setCamera(newCamera);
        uow.commit();
    }

    @Override
    public void reset() {
        super.reset();
        this.original = null;
        this.original2 = null;
    }
}

