/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import java.util.ArrayList;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.optimisticlocking.Camera;
import org.eclipse.persistence.testing.models.optimisticlocking.Gamer;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsole;
import org.eclipse.persistence.testing.models.optimisticlocking.PowerSupplyUnit;
import org.eclipse.persistence.testing.tests.optimisticlocking.SwitchableOptimisticLockingPolicyTest;

public class UpdateNullManyToManyValueTest
extends SwitchableOptimisticLockingPolicyTest {
    protected GamesConsole original;
    protected GamesConsole original2;

    public UpdateNullManyToManyValueTest(Class<?> optimisticLockingPolicyClass) {
        super(optimisticLockingPolicyClass);
        this.addClassToModify(Gamer.class);
        this.addClassToModify(GamesConsole.class);
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = new GamesConsole("PloughStation4", "black");
        this.original.setCamera(new Camera("eye", "black"));
        this.original.setPsu(new PowerSupplyUnit("0-123-456-789"));
        this.original2 = new GamesConsole();
        this.original2.setName("Segone");
        uow.registerObject((Object)this.original);
        uow.registerObject((Object)this.original2);
        uow.commit();
    }

    public void test() throws TestException {
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.readObjectAndAddIntoCollection(new Gamer("testy", null), false);
            this.updateFirstObject();
            this.readObjectAndAddIntoCollection(new Gamer("t4h_fury", "pwner"), false);
            this.readObjectAndAddIntoCollection(new Gamer("t5h_fury", null), false);
            this.readObjectAndAddIntoCollection(new Gamer("t6h_fury", "pwner"), false);
            this.readObjectAndAddIntoCollection(null, true);
            this.readObjectAndAddIntoCollection(new Gamer(null, "pwner"), true);
            this.updateFirstObject();
            this.readObjectAndAddIntoCollection(new Gamer("t8h_fury", null), false);
            this.readObjectAndAddIntoCollection(new Gamer("t9h_fury", "pwner"), false);
            this.readObjectAndAddIntoCollection(null, true);
            this.readObjectAndAddIntoCollection(new Gamer("10_fury", "pwner"), true);
            this.updateFirstObject();
            this.readObjectAndAddIntoCollection(new Gamer(null, "pwner"), true);
            this.updateFirstObject();
            this.readObjectAndAddIntoCollection(new Gamer(null, null), true);
            this.updateFirstObject();
            this.readObjectAndAddIntoCollection(new Gamer("13_fury", null), true);
            this.updateFirstObject();
            this.readObjectAndAddIntoCollection(new Gamer("14_fury", "pwner"), true);
            this.updateFirstObject();
            this.readObjectAndAddIntoCollection(null, true);
            this.deleteObject(this.original);
            this.deleteObject(this.original2);
        }
        catch (Exception tle) {
            this.tlException = tle;
            this.tlException.printStackTrace();
        }
    }

    public void readObjectAndAddIntoCollection(Gamer newGamer, boolean removeAll) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        GamesConsole clone = (GamesConsole)uow.readObject(GamesConsole.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullManyToManyValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        if (removeAll) {
            for (Gamer g : new ArrayList<Gamer>(clone.getGamers())) {
                g.setName(null);
                clone.removeGamer(g);
            }
        }
        if (newGamer != null) {
            clone.addGamer(newGamer);
        }
        uow.commit();
    }

    public void updateFirstObject() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        GamesConsole clone = (GamesConsole)uow.readObject(GamesConsole.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullManyToManyValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        if (!clone.getGamers().isEmpty()) {
            Gamer g = clone.getGamers().get(0);
            g.setDescription(null);
            g.setName(null);
        }
        uow.commit();
    }

    @Override
    public void reset() {
        super.reset();
        this.original = null;
        this.original2 = null;
    }
}

