/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.interfaces.Employee;
import org.eclipse.persistence.testing.models.interfaces.Phone;

public class VariableOneToOneUpdateTest
extends TransactionalTestCase {
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee emp = (Employee)uow.registerObject((Object)Employee.example1());
        emp.setName("Guy");
        uow.commit();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee e = (Employee)uow.registerObject(uow.readObject(Employee.class, new ExpressionBuilder().get("name").equal((Object)"Guy")));
        e.setName("Guy Pelletier");
        Phone p = Phone.example3();
        p.setNumber("6138236262");
        e.setContact(p);
        p.setEmp(e);
        uow.commit();
    }

    public void verify() {
        Employee empFromDb = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("name").equal((Object)"Guy Pelletier"));
        if (empFromDb == null) {
            throw new TestErrorException("The employee NAME was not updated correctly in the database");
        }
        if (!((Phone)empFromDb.getContact()).getNumber().equals("6138236262")) {
            throw new TestErrorException("The employee PHONE was not updated correctly in the database");
        }
    }
}

