/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import java.util.Iterator;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.collections.Diner;
import org.eclipse.persistence.testing.models.collections.Location;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.MenuItem;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class UnitOfWorkTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;

    public UnitOfWorkTest() {
    }

    public UnitOfWorkTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Restaurant restaurant = (Restaurant)this.unitOfWorkWorkingCopy;
        Location location = (Location)restaurant.getLocations().iterator().next();
        restaurant.getLocations().remove(location);
        ((Menu)restaurant.getMenus().get("dinner")).getItems().add(MenuItem.example17((Menu)restaurant.getMenus().get("dinner")));
        Iterator iter = restaurant.getPreferredCustomers().values().iterator();
        Diner aDiner = (Diner)iter.next();
        aDiner.setFirstName(aDiner.getFirstName() + " B.");
        restaurant.getLocations().add(Location.example6());
        String aSlogan = (String)restaurant.getSlogans().iterator().next();
        restaurant.getSlogans().remove(aSlogan);
        restaurant.getSlogans().add("100% Java");
        restaurant.addMenu(new Menu("snack"));
        restaurant.addMenu(new Menu("four oclock tea"));
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.unitOfWork.commit();
    }

    protected void verify() {
        this.getSession().logMessage("working copy     Restaurant: " + this.unitOfWorkWorkingCopy);
        this.getSession().logMessage("objectToBeWriten Restaurant: " + this.objectToBeWritten);
        if (!this.compareObjects(this.unitOfWorkWorkingCopy, this.objectToBeWritten)) {
            throw new TestErrorException("The object in the unit of work has not been commited properly to its parent");
        }
        super.verify();
    }
}

