/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Denise Smith - initial API and implementation
package org.eclipse.persistence.testing.jaxb.xmlvalue;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Arrays;

public class BytesHolderWithXmlId {

    @XmlValue
    public byte[] theBytes;

    @XmlAttribute(name = "Id")
    @XmlID
    @XmlSchemaType(name = "ID")
    public String id;

    public boolean equals(Object o) {
        if(!(o instanceof BytesHolderWithXmlId) || o == null) {
            return false;
        } else {
            if (theBytes == null){
                if(((BytesHolderWithXmlId)o).theBytes != null){
                    return false;
                }
            }else {
                if(((BytesHolderWithXmlId)o).theBytes == null){
                    return false;
                }
            }
            if (theBytes.length != ((BytesHolderWithXmlId)o).theBytes.length){
                return false;
            }
            for (int i=0; i<theBytes.length; i++) {
                if (theBytes[i] != ((BytesHolderWithXmlId)o).theBytes[i]) {
                    return false;
                }
            }
            if(id == null){
                if( ((BytesHolderWithXmlId)o).id != null){
                    return false;
                }
            }else if(!id.equals(((BytesHolderWithXmlId)o).id)){
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = theBytes != null ? Arrays.hashCode(theBytes) : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        return result;
    }
}
