/*
 * Copyright (c) 1998, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
 package org.eclipse.persistence.testing.tests.junit.failover.emulateddriver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.util.Calendar;

public class EmulatedStatement implements PreparedStatement {

    protected EmulatedConnection connection;
    protected String sql;

    public EmulatedStatement(EmulatedConnection connection) {
        this.connection = connection;
    }

    public EmulatedStatement(String sql, EmulatedConnection connection) {
        this(connection);
        this.sql = sql;
    }


    public void checkForError() throws SQLException{
        if ((connection).isInFailureState()){
            SQLException exception = new SQLException("Communication Failure occurred", "", 17004);
            throw exception;
        }
    }


    @Override
    public boolean execute() throws SQLException {
        checkForError();
        return true;
    }


    @Override
    public boolean execute(String sql) throws SQLException {
        checkForError();
        return true;
    }


    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        checkForError();
        return true;
    }


    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        checkForError();
        return true;
    }


    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        checkForError();
        return true;
    }


    @Override
    public ResultSet executeQuery() throws SQLException {
        checkForError();
        return new EmulatedResultSet(this.connection.getRows(this.sql));
    }


    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        checkForError();
        return new EmulatedResultSet(this.connection.getRows(sql));
    }


    @Override
    public int executeUpdate() throws SQLException {
        checkForError();
        return 1;
    }


    @Override
    public int executeUpdate(String sql) throws SQLException {
        checkForError();
        return 1;
    }


    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        checkForError();
        return 1;
    }


    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        checkForError();
        return 1;
    }


    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        checkForError();
        return 1;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) {
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
    }

    @Override
    public void setByte(int parameterIndex, byte x) {
    }

    @Override
    public void setShort(int parameterIndex, short x) {
    }

    @Override
    public void setInt(int parameterIndex, int x) {
    }

    @Override
    public void setLong(int parameterIndex, long x) {
    }

    @Override
    public void setFloat(int parameterIndex, float x) {
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
    }


    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) {
    }


    @Override
    public void setString(int parameterIndex, String x) {
    }


    @Override
    public void setBytes(int parameterIndex, byte[] x) {
    }


    @Override
    public void setDate(int parameterIndex, java.sql.Date x) {
    }


    @Override
    public void setTime(int parameterIndex, java.sql.Time x) {
    }


    @Override
    public void setTimestamp(int parameterIndex, java.sql.Timestamp x) {
    }


    @Override
    public void setAsciiStream(int parameterIndex, java.io.InputStream x, int length) {
    }


    @Override
    public void setUnicodeStream(int parameterIndex, java.io.InputStream x, int length) {
    }


    @Override
    public void setBinaryStream(int parameterIndex, java.io.InputStream x, int length) {
    }


    @Override
    public void clearParameters() {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) {
    }


    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) {
    }


    @Override
    public void setObject(int parameterIndex, Object x) {
    }

    @Override
    public void addBatch() {
    }


    @Override
    public void setCharacterStream(int parameterIndex, java.io.Reader reader, int length) {
    }


    @Override
    public void setRef(int i, Ref x) {
    }


    @Override
    public void setBlob(int i, Blob x) {
    }


    @Override
    public void setClob(int i, Clob x) {
    }


    @Override
    public void setArray(int i, Array x) {
    }


    @Override
    public ResultSetMetaData getMetaData() {
        return null;
    }


    @Override
    public void setDate(int parameterIndex, java.sql.Date x, Calendar cal) {
    }


    @Override
    public void setTime(int parameterIndex, java.sql.Time x, Calendar cal) {
    }


    @Override
    public void setTimestamp(int parameterIndex, java.sql.Timestamp x, Calendar cal) {
    }


    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) {
    }


    @Override
    public void setURL(int parameterIndex, java.net.URL x) {
    }


    @Override
    public ParameterMetaData getParameterMetaData() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public ResultSet getResultSet() {
        return null;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchDirection() {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() {
        return 0;
    }
    @Override
    public int getResultSetType() {
        return 0;
    }

    @Override
    public void addBatch(String sql) {
    }

    @Override
    public void clearBatch() {
    }

    @Override
    public int[] executeBatch(){
        return null;
    }
    @Override
    public Connection getConnection() {
        return connection;
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return null;
    }

    @Override
    public int getResultSetHoldability() {
        return 0;
    }

    // 236070: Methods introduced in JDK 1.6

   @Override
   public void setAsciiStream(int columnIndex, InputStream stream, long length)  throws SQLException {
   }

   @Override
   public void setAsciiStream(int columnIndex, InputStream stream)  throws SQLException {
   }

   public void setAsciiStream(String columnLabel, InputStream stream, long length)  throws SQLException {
   }

   public void setAsciiStream(String columnLabel, InputStream stream)  throws SQLException {
   }

   @Override
   public void setBlob(int columnIndex, InputStream stream, long length)  throws SQLException {
   }

   @Override
   public void setBlob(int columnIndex, InputStream stream)  throws SQLException {
   }

   public void setBlob(String columnLabel, InputStream stream, long length)  throws SQLException {
   }

   public void setBlob(String columnLabel, InputStream stream)  throws SQLException {
   }

   @Override
   public void setBinaryStream(int columnIndex, InputStream stream, long length)  throws SQLException {
   }

   @Override
   public void setBinaryStream(int columnIndex, InputStream stream)  throws SQLException {
   }

   public void setBinaryStream(String columnLabel, InputStream stream, long length)  throws SQLException {
   }

   public void setBinaryStream(String columnLabel, InputStream stream)  throws SQLException {
   }

   @Override
   public void setCharacterStream(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   @Override
   public void setCharacterStream(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setCharacterStream(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setCharacterStream(String columnLabel, Reader reader)  throws SQLException {
   }

   @Override
   public void setClob(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   @Override
   public void setClob(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setClob(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setClob(String columnLabel, Reader reader)  throws SQLException {
   }

   @Override
   public void setNCharacterStream(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   @Override
   public void setNCharacterStream(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setNCharacterStream(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setNCharacterStream(String columnLabel, Reader reader)  throws SQLException {
   }

   @Override
   public void setNClob(int columnIndex, Reader reader, long length)  throws SQLException {
   }

   @Override
   public void setNClob(int columnIndex, Reader reader)  throws SQLException {
   }

   public void setNClob(String columnLabel, Reader reader, long length)  throws SQLException {
   }

   public void setNClob(String columnLabel, Reader reader)  throws SQLException {
   }

   @Override
   public void setNClob(int columnIndex, NClob nclob)  throws SQLException {
   }

   public void setNClob(String columnLabel, NClob nclob)  throws SQLException {
   }

   @Override
   public void setNString(int columnIndex, String nString)  throws SQLException {
   }

   public void setNString(String columnLabel, String nString)  throws SQLException {
   }

   public void setSQLXML(String columnLabel, SQLXML sqlxml)  throws SQLException {
   }

   @Override
   public void setSQLXML(int columnIndex, SQLXML sqlxml)  throws SQLException {
   }

   @Override
   public void setRowId(int columnIndex, RowId rowid)  throws SQLException {
   }

   public void setRowId(String columnLabel, RowId rowid)  throws SQLException {
   }

   @Override
   public boolean isClosed()  throws SQLException {
       return false;
   }

   @Override
   public boolean isPoolable()  throws SQLException {
       return false;
   }

   @Override
   public void setPoolable(boolean poolable)  throws SQLException {
   }

    // From java.sql.Wrapper
    @Override
    public boolean isWrapperFor(Class<?> iFace) throws SQLException{
        return false;
    }

    @Override
    public <T>T unwrap(Class<T> iFace)  throws SQLException {
        return iFace.cast(this);
    }

    @Override
    public boolean isCloseOnCompletion(){return false;}

    @Override
    public void closeOnCompletion(){}
}
