/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.buildtools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.persistence.buildtools.helper.Version;

public class StripQualifier
extends Task {
    private String input = null;
    private String property = null;
    private Version version = null;

    public void execute() throws BuildException {
        if (this.input == null) {
            throw new BuildException("'input' attribute must be set.", this.getLocation());
        }
        if (this.property == null) {
            throw new BuildException("'property' attribute must be set.", this.getLocation());
        }
        if (this.property == "") {
            throw new BuildException("'property' cannot be an empty string.", this.getLocation());
        }
        if (this.input.startsWith("${") || this.input.startsWith("@{") || this.input == "") {
            this.log("StripQualifier finished.  Input empty or search failed! original value was '" + this.input + "'.", 3);
            throw new BuildException("'input' is empty, or a property value cannot be expanded.", this.getLocation());
        }
        if (this.getProject().getProperty(this.property) == null) {
            this.version = new Version(this.input);
            this.getProject().setProperty(this.property, this.version.get3PartStr());
            this.log("StripQualifier finished. Old string of '" + this.input + "' set to '" + this.version.get3PartStr() + "' in property '" + this.property + "'.", 3);
        } else {
            this.log("StripQualifier finished. Property '" + this.property + "' already set to '" + this.getProject().getProperty(this.property) + "'. Skipping.", 3);
        }
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

