/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.bigbad.BigBadObject;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ConcurrentReadBigBadObjectTest
extends AutoVerifyTestCase {
    BigBadObject referenceObject;
    protected int numOftries = 300;
    protected int numOfThreads = 10;
    protected boolean failed;
    protected Server server;
    protected int OrigDirectMapWeight;

    public void setup() throws Exception {
        DatabaseMapping m;
        DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.server = new Server(login);
        this.server.serverSession.setLogLevel(this.getSession().getLogLevel());
        this.server.serverSession.setLog(this.getSession().getLog());
        this.server.copyDescriptors(this.getSession());
        ClassDescriptor d = this.server.serverSession.getClassDescriptor(BigBadObject.class);
        Vector v = d.getMappings();
        int mappings = v.size();
        for (int i = 0; i < mappings; ++i) {
            m = (DatabaseMapping)v.get(i);
            m.setWeight(Integer.valueOf(0x7FFFFFFE));
        }
        m = d.getMappingForAttributeName("number02");
        m.setWeight(Integer.valueOf(Integer.MAX_VALUE));
        this.server.login();
        this.server.serverSession.setLogLevel(this.getSession().getLogLevel());
        this.server.serverSession.setLog(this.getSession().getLog());
    }

    public void reset() throws Exception {
        this.server.logout();
    }

    public void test() {
        this.failed = false;
        this.referenceObject = (BigBadObject)this.getSession().readObject(BigBadObject.class);
        Reader[] threadList = new Reader[this.numOfThreads];
        int i = 0;
        while (i < this.numOfThreads) {
            threadList[i++] = new Reader(this.referenceObject, (Session)this.server.serverSession.acquireClientSession(), i);
        }
        for (i = 0; i < this.numOfThreads; ++i) {
            threadList[i].start();
        }
        try {
            for (i = 0; i < this.numOfThreads; ++i) {
                threadList[i].join();
            }
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        for (int count = 0; !this.failed && count < this.numOfThreads; ++count) {
            if (threadList[count].exception != null) {
                throw threadList[count].exception;
            }
            this.failed = threadList[count].hadError();
        }
        if (this.failed) {
            throw new TestErrorException("Test failed, getFromIdentityMap returned an object before it was finished being built");
        }
    }

    private class Reader
    extends Thread {
        protected BigBadObject referenceObject;
        protected BigBadObject readObject;
        protected Session session;
        public int thread;
        public int counter;
        public RuntimeException exception;
        protected boolean experienceError = false;

        public Reader(BigBadObject object, Session session, int thread) {
            this.referenceObject = object;
            this.session = session;
            this.thread = thread;
            this.counter = 0;
        }

        @Override
        public void run() {
            try {
                this.counter = 0;
                while (!this.experienceError && this.counter < ConcurrentReadBigBadObjectTest.this.numOftries) {
                    if (this.thread == 1) {
                        this.session.getIdentityMapAccessor().initializeIdentityMap(BigBadObject.class);
                        this.readObject = (BigBadObject)this.session.readObject((Object)this.referenceObject);
                    } else {
                        this.readObject = (BigBadObject)this.session.getIdentityMapAccessor().getFromIdentityMap((Object)this.referenceObject);
                    }
                    if (!(this.readObject == null || this.readObject.number02 != null && this.readObject.number02.equals(this.referenceObject.number02))) {
                        this.experienceError = true;
                    }
                    ++this.counter;
                }
            }
            catch (RuntimeException ex) {
                this.experienceError = true;
                this.exception = ex;
            }
        }

        public boolean hadError() {
            return this.experienceError;
        }
    }
}

