/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.filter.Filter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class ServiceRequest
extends RequestMessage {
    ServiceType serviceType;
    Filter predicate;
    String spi;

    ServiceRequest(ServiceType type, List scopes, String filterStr, Locale theLocale) throws IllegalArgumentException {
        this.funcID = 1;
        this.prevRespList = new ArrayList();
        this.serviceType = type;
        this.predicate = filterStr == null ? null : SLPCore.platform.createFilter(filterStr);
        this.scopeList = scopes;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.locale = theLocale == null ? SLPCore.DEFAULT_LOCALE : theLocale;
        this.spi = SLPCore.CONFIG.getSecurityEnabled() ? SLPCore.CONFIG.getSPI() : "";
    }

    protected ServiceRequest(DataInputStream input) throws IOException {
        this.prevRespList = ServiceRequest.stringToList(input.readUTF(), ",");
        this.serviceType = new ServiceType(input.readUTF());
        this.scopeList = ServiceRequest.stringToList(input.readUTF(), ",");
        try {
            String filterStr = input.readUTF();
            this.predicate = "".equals(filterStr) ? null : SLPCore.platform.createFilter(filterStr);
        }
        catch (IllegalArgumentException ise) {
            SLPCore.platform.logError("Invalid filter in incoming message " + this.xid, ise);
        }
        this.spi = input.readUTF();
    }

    @Override
    protected void writeTo(DataOutputStream out) throws IOException {
        out.writeUTF(ServiceRequest.listToString(this.prevRespList, ","));
        out.writeUTF(this.serviceType.toString());
        out.writeUTF(ServiceRequest.listToString(this.scopeList, ","));
        out.writeUTF(this.predicate == null ? "" : this.predicate.toString());
        out.writeUTF(this.spi);
    }

    @Override
    protected int getSize() {
        return this.getHeaderSize() + 2 + ServiceRequest.listToString(this.prevRespList, ",").length() + 2 + this.serviceType.toString().length() + 2 + ServiceRequest.listToString(this.scopeList, ",").length() + 2 + (this.predicate == null ? 0 : this.predicate.toString().length()) + 2 + this.spi.length();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(", prevRespList: " + this.prevRespList);
        buffer.append(", serviceType: " + this.serviceType);
        buffer.append(", scopeList: " + this.scopeList);
        buffer.append(", predicate: " + (this.predicate == null ? "" : this.predicate.toString()));
        buffer.append(", slpSpi: " + this.spi);
        return buffer.toString();
    }
}

