/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractAutoEditTest
extends AbstractEditorTest {
    private List<IFile> files = Lists.newArrayList();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.closeWelcomePage();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.files.clear();
        this.closeEditors();
        super.tearDown();
    }

    protected abstract String getFileExtension();

    protected XtextEditor openEditor(String string) throws Exception {
        int cursor = string.indexOf(124);
        String fileExtension = this.getFileExtension();
        IFile file = IResourcesSetupUtil.createFile("foo/myfile" + this.files.size() + "." + fileExtension, string.replace("|", ""));
        this.files.add(file);
        XtextEditor editor = this.openEditor(file);
        editor.getInternalSourceViewer().setSelectedRange(cursor, 0);
        editor.getInternalSourceViewer().getTextWidget().setFocus();
        return editor;
    }

    protected void assertState(String string, XtextEditor editor) {
        this.assertState(editor, string);
    }

    protected void assertState(XtextEditor editor, String string) {
        int cursor = string.indexOf(124);
        AbstractAutoEditTest.assertEquals((Object)string.replace("|", ""), (Object)editor.getDocument().get());
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        AbstractAutoEditTest.assertEquals((String)"unexpected cursor position:", (long)cursor, (long)selection.getOffset());
    }

    protected void selectText(XtextEditor editor, int relativeToCurrentOffset, int length) throws Exception {
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        editor.getInternalSourceViewer().setSelectedRange(selection.getOffset() + relativeToCurrentOffset, length);
    }

    protected void pressKey(XtextEditor editor, char c) throws Exception {
        StyledText textWidget = editor.getInternalSourceViewer().getTextWidget();
        Event e = new Event();
        e.character = c;
        e.type = 1;
        e.doit = true;
        if (c == '\u001b') {
            e.keyCode = 27;
        }
        textWidget.notifyListeners(1, e);
    }

    protected void pasteText(XtextEditor editor, String text) throws Exception {
        StyledText textWidget = editor.getInternalSourceViewer().getTextWidget();
        Point selection = textWidget.getSelection();
        Event event = new Event();
        event.start = selection.x;
        event.end = selection.y;
        event.text = text;
        event.keyCode = KeyLookupFactory.getDefault().getCtrl();
        textWidget.notifyListeners(1, event);
        Method sendKeyEvent = textWidget.getClass().getDeclaredMethod("sendKeyEvent", Event.class);
        sendKeyEvent.setAccessible(true);
        sendKeyEvent.invoke((Object)textWidget, event);
    }

    protected void pressKeys(XtextEditor editor, String string) throws Exception {
        int i = 0;
        while (i < string.length()) {
            this.pressKey(editor, string.charAt(i));
            ++i;
        }
    }

    protected List<IFile> getFiles() {
        return this.files;
    }
}

