/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAggregateAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;

public class TmfViewsElement
extends TmfProjectModelElement {
    public static final String PATH_ELEMENT = ".views";
    private static final String ELEMENT_NAME = Messages.TmfViewsElement_Name;

    protected TmfViewsElement(IResource resource, TmfCommonProjectElement parent) {
        super(ELEMENT_NAME, resource, parent);
    }

    @Override
    public TmfCommonProjectElement getParent() {
        return (TmfCommonProjectElement)super.getParent();
    }

    @Override
    protected void refreshChildren() {
        block15: {
            TmfCommonProjectElement parent;
            IPath nodePath;
            Class traceClass;
            HashMap<String, TmfAnalysisElement> childrenMap;
            block14: {
                childrenMap = new HashMap<String, TmfAnalysisElement>();
                for (TmfAnalysisElement analysis : this.getParent().getAvailableAnalysis()) {
                    childrenMap.put(analysis.getAnalysisId(), analysis);
                }
                TraceTypeHelper helper = TmfTraceType.getTraceType((String)this.getParent().getTraceType());
                traceClass = null;
                if (helper != null) {
                    traceClass = helper.getTraceClass();
                }
                if (traceClass == null) {
                    for (TmfAnalysisElement analysis : childrenMap.values()) {
                        this.removeChild(analysis);
                    }
                    return;
                }
                nodePath = this.getResource().getFullPath();
                parent = this.getParent();
                if (!(parent instanceof TmfTraceElement)) break block14;
                for (IAnalysisModuleHelper module : TmfAnalysisManager.getAnalysisModules((Class)traceClass).values()) {
                    TmfAnalysisElement analysis = (TmfAnalysisElement)childrenMap.remove(module.getId());
                    if (analysis == null) {
                        IFolder analysisRes = ResourcesPlugin.getWorkspace().getRoot().getFolder(nodePath.append(module.getId()));
                        analysis = new TmfAnalysisElement(module.getName(), (IResource)analysisRes, this, module);
                        this.addChild(analysis);
                    }
                    analysis.refreshChildren();
                }
                for (TmfAnalysisElement analysis : childrenMap.values()) {
                    this.removeChild(analysis);
                }
                break block15;
            }
            if (parent == null) break block15;
            HashMap<String, TmfAggregateAnalysisElement> analysisMap = new HashMap<String, TmfAggregateAnalysisElement>();
            for (IAnalysisModuleHelper module : TmfAnalysisManager.getAnalysisModules((Class)traceClass).values()) {
                TmfAnalysisElement analysis = (TmfAnalysisElement)childrenMap.remove(module.getId());
                TmfAggregateAnalysisElement aggregateAnalysisElement = null;
                if (analysis == null) {
                    IFolder analysisRes = ResourcesPlugin.getWorkspace().getRoot().getFolder(nodePath.append(module.getId()));
                    analysis = new TmfAnalysisElement(module.getName(), (IResource)analysisRes, this, module);
                    aggregateAnalysisElement = new TmfAggregateAnalysisElement(parent, analysis);
                    this.addChild(aggregateAnalysisElement);
                } else {
                    aggregateAnalysisElement = analysis instanceof TmfAggregateAnalysisElement ? (TmfAggregateAnalysisElement)analysis : new TmfAggregateAnalysisElement(parent, analysis);
                    this.removeChild(analysis);
                    this.addChild(aggregateAnalysisElement);
                }
                analysisMap.put(analysis.getAnalysisId(), aggregateAnalysisElement);
            }
            for (TmfAnalysisElement analysis : this.getParent().getAvailableChildrenAnalyses()) {
                TmfAnalysisElement a = (TmfAnalysisElement)childrenMap.remove(analysis.getAnalysisId());
                TmfAggregateAnalysisElement childAnalysis = null;
                childAnalysis = a instanceof TmfAggregateAnalysisElement ? (TmfAggregateAnalysisElement)a : (TmfAggregateAnalysisElement)analysisMap.get(analysis.getAnalysisId());
                if (childAnalysis == null) {
                    childAnalysis = new TmfAggregateAnalysisElement(parent, analysis);
                    this.addChild(childAnalysis);
                } else {
                    childAnalysis.addAnalyses(analysis);
                }
                analysisMap.put(analysis.getAnalysisId(), childAnalysis);
            }
            for (TmfAnalysisElement analysis : childrenMap.values()) {
                this.removeChild(analysis);
            }
        }
    }

    @Override
    public Image getIcon() {
        return TmfProjectModelIcons.VIEWS_ICON;
    }

    public void removeChildrenAnalysis(List<@NonNull TmfAnalysisElement> analysisElements) {
        for (TmfAnalysisElement tmfAnalysisElement : analysisElements) {
            TmfAggregateAnalysisElement aggrElement = this.getAggregateAnalysisElement(tmfAnalysisElement);
            if (aggrElement == null) continue;
            aggrElement.removeAnalyses(tmfAnalysisElement);
            if (!aggrElement.isEmpty()) continue;
            this.removeChild(aggrElement);
        }
    }

    private TmfAggregateAnalysisElement getAggregateAnalysisElement(TmfAnalysisElement element) {
        return this.getChildren().stream().filter(TmfAggregateAnalysisElement.class::isInstance).map(elem -> (TmfAggregateAnalysisElement)elem).filter(elem -> elem.getAnalysisHelper().getId().equals(element.getAnalysisHelper().getId())).findFirst().orElse(null);
    }
}

