/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfProjectModelHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public abstract class TmfProjectModelElement
implements ITmfProjectModelElement {
    private final String fName;
    private final IResource fResource;
    private final URI fLocation;
    private final IPath fPath;
    private final ITmfProjectModelElement fParent;
    private final @NonNull List<ITmfProjectModelElement> fChildren;

    protected TmfProjectModelElement(String name, IResource resource, ITmfProjectModelElement parent) {
        this.fName = name;
        this.fResource = resource;
        this.fPath = resource.getFullPath();
        this.fLocation = new File(resource.getLocationURI()).toURI();
        this.fParent = parent;
        this.fChildren = new CopyOnWriteArrayList<ITmfProjectModelElement>();
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public URI getLocation() {
        return this.fLocation;
    }

    @Override
    public TmfProjectElement getProject() {
        return this.fParent.getProject();
    }

    @Override
    public ITmfProjectModelElement getParent() {
        return this.fParent;
    }

    @Override
    public List<ITmfProjectModelElement> getChildren() {
        return ImmutableList.copyOf(this.fChildren);
    }

    @Override
    public void refresh() {
        this.refreshChildren();
        this.refreshViewer();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fPath == null ? 0 : this.fPath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        TmfProjectModelElement element = (TmfProjectModelElement)other;
        return element.fPath.equals((Object)this.fPath);
    }

    protected abstract void refreshChildren();

    public void refreshViewer() {
        Display.getDefault().asyncExec(() -> {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow wbWindow = wb.getActiveWorkbenchWindow();
            if (wbWindow == null) {
                return;
            }
            IWorkbenchPage activePage = wbWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IViewReference[] iViewReferenceArray = activePage.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                IViewPart viewPart = viewReference.getView(false);
                if (viewPart instanceof CommonNavigator) {
                    IProject project;
                    CommonViewer commonViewer = ((CommonNavigator)viewPart).getCommonViewer();
                    TmfProjectModelElement element = this;
                    if (element instanceof TmfProjectElement && (project = (IProject)this.getResource()) != null && !TmfProjectModelHelper.isShadowProject(project)) {
                        element = this.getResource();
                    }
                    commonViewer.refresh((Object)element);
                }
                ++n2;
            }
        });
    }

    protected void addChild(ITmfProjectModelElement child) {
        this.fChildren.add(child);
    }

    protected void removeChild(ITmfProjectModelElement child) {
        this.fChildren.remove(child);
        child.dispose();
    }

    public IFolder getTraceSupplementaryFolder(String supplFolderPath) {
        TmfProjectElement project = this.getProject();
        IFolder supplFolderParent = project.getSupplementaryFolder();
        return supplFolderParent.getFolder(supplFolderPath);
    }

    public IFolder prepareTraceSupplementaryFolder(String supplFolderPath, boolean createFolder, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        IFolder folder = this.getTraceSupplementaryFolder(supplFolderPath);
        IFolder propertiesFolder = folder.getFolder(".properties");
        if (createFolder && propertiesFolder.exists() && propertiesFolder.isHidden() || !createFolder && folder.getParent().exists()) {
            return folder;
        }
        try {
            ICoreRunnable runnable = monitor -> {
                if (createFolder) {
                    TraceUtils.createFolder(propertiesFolder, monitor);
                    propertiesFolder.setHidden(true);
                } else {
                    TraceUtils.createFolder((IFolder)folder.getParent(), monitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)folder.getProject(), 1, (IProgressMonitor)subMonitor);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error creating supplementary folder " + folder.getFullPath(), e);
        }
        return folder;
    }

    public IFolder prepareTraceSupplementaryFolder(String supplFolderPath, boolean createFolder) {
        return this.prepareTraceSupplementaryFolder(supplFolderPath, createFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '(' + this.getPath() + ')';
    }
}

