/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunctionStatistics;

public class AggregatedCalledFunction
implements Cloneable {
    private final Object fSymbol;
    private final int fDepth;
    private final int fMaxDepth;
    private final Map<Object, AggregatedCalledFunction> fChildren = new HashMap<Object, AggregatedCalledFunction>();
    private final @Nullable AggregatedCalledFunction fParent;
    private final AggregatedCalledFunctionStatistics fStatistics;
    private long fDuration;
    private long fSelfTime;
    private final int fProcessId;

    public AggregatedCalledFunction(AbstractCalledFunction calledFunction, AggregatedCalledFunction parent) {
        this.fSymbol = calledFunction.getSymbol();
        this.fDuration = calledFunction.getLength();
        this.fSelfTime = calledFunction.getLength();
        this.fDepth = calledFunction.getDepth();
        this.fProcessId = calledFunction.getProcessId();
        this.fMaxDepth = parent.getMaxDepth();
        this.fParent = parent;
        this.fStatistics = new AggregatedCalledFunctionStatistics();
    }

    public AggregatedCalledFunction(AbstractCalledFunction calledFunction, int maxDepth) {
        this.fSymbol = calledFunction.getSymbol();
        this.fDuration = calledFunction.getLength();
        this.fSelfTime = calledFunction.getLength();
        this.fDepth = calledFunction.getDepth();
        this.fProcessId = calledFunction.getProcessId();
        this.fMaxDepth = maxDepth;
        this.fParent = null;
        this.fStatistics = new AggregatedCalledFunctionStatistics();
    }

    private AggregatedCalledFunction(AggregatedCalledFunction toCopy) {
        this.fSymbol = toCopy.fSymbol;
        for (Map.Entry<Object, AggregatedCalledFunction> entry : toCopy.fChildren.entrySet()) {
            this.fChildren.put(entry.getKey(), entry.getValue().clone());
        }
        this.fParent = toCopy.fParent;
        this.fMaxDepth = toCopy.fMaxDepth;
        this.fDepth = toCopy.fDepth;
        this.fStatistics = new AggregatedCalledFunctionStatistics();
        this.fStatistics.merge(toCopy.fStatistics);
        this.fProcessId = toCopy.fProcessId;
        this.fDuration = toCopy.fDuration;
        this.fSelfTime = toCopy.fSelfTime;
    }

    public Object getSymbol() {
        return this.fSymbol;
    }

    public synchronized Collection<AggregatedCalledFunction> getChildren() {
        return this.fChildren.values();
    }

    public @Nullable AggregatedCalledFunction getParent() {
        return this.fParent;
    }

    public synchronized void addChild(AbstractCalledFunction child, AggregatedCalledFunction aggregatedChild) {
        this.fSelfTime -= aggregatedChild.getDuration();
        aggregatedChild.getFunctionStatistics().update(child);
        AggregatedCalledFunction node = this.fChildren.get(aggregatedChild.getSymbol());
        if (node == null) {
            this.fChildren.put(aggregatedChild.getSymbol(), aggregatedChild);
        } else {
            AggregatedCalledFunction.merge(node, aggregatedChild);
        }
    }

    public @NonNull AggregatedCalledFunction clone() {
        return new AggregatedCalledFunction(this);
    }

    private void addToDuration(long duration) {
        this.fDuration += duration;
    }

    private static void mergeChildren(AggregatedCalledFunction firstNode, AggregatedCalledFunction secondNode) {
        for (Map.Entry<Object, AggregatedCalledFunction> functionEntry : secondNode.fChildren.entrySet()) {
            Object childSymbol = Objects.requireNonNull(functionEntry.getKey());
            AggregatedCalledFunction secondNodeChild = Objects.requireNonNull(functionEntry.getValue());
            AggregatedCalledFunction aggregatedCalledFunction = firstNode.fChildren.get(childSymbol);
            if (aggregatedCalledFunction == null) {
                firstNode.fChildren.put(secondNodeChild.getSymbol(), secondNodeChild);
                continue;
            }
            AggregatedCalledFunction.merge(aggregatedCalledFunction, secondNodeChild);
        }
    }

    private static void merge(AggregatedCalledFunction destination, AggregatedCalledFunction source) {
        destination.addToDuration(source.getDuration());
        destination.addToSelfTime(source.getSelfTime());
        destination.getFunctionStatistics().merge(source.getFunctionStatistics());
        AggregatedCalledFunction.mergeChildren(destination, source);
    }

    public long getDuration() {
        return this.fDuration;
    }

    public int getDepth() {
        return this.fDepth;
    }

    public int getMaxDepth() {
        return this.fMaxDepth;
    }

    public long getNbCalls() {
        return this.fStatistics.getDurationStatistics().getNbElements();
    }

    public long getSelfTime() {
        return this.fSelfTime;
    }

    public void addToSelfTime(long selfTime) {
        this.fSelfTime += selfTime;
    }

    public int getProcessId() {
        return this.fProcessId;
    }

    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public AggregatedCalledFunctionStatistics getFunctionStatistics() {
        return this.fStatistics;
    }

    public String toString() {
        return "Aggregate Function: " + this.getSymbol() + ", Duration: " + this.getDuration() + ", Self Time: " + this.fSelfTime + " on " + this.getNbCalls() + " calls";
    }
}

