/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.DefaultActionImage;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireHotSpotsActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class SapphireToolBarActionPresentation
extends SapphireHotSpotsActionPresentation {
    private ToolBar toolbar;
    private Map<SapphireAction, Listener> listeners;

    public SapphireToolBarActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
    }

    public ToolBar getToolBar() {
        return this.toolbar;
    }

    public void setToolBar(ToolBar toolbar) {
        this.toolbar = toolbar;
    }

    @Override
    public void render() {
        final SwtPresentation context = (SwtPresentation)this.getManager().context();
        boolean first = true;
        String lastGroup = null;
        this.listeners = new HashMap<SapphireAction, Listener>();
        for (final SapphireAction action : this.getActions()) {
            SelectionAdapter toolItemListener;
            ToolItem toolItem;
            String group = action.getGroup();
            if (!first && !MiscUtil.equal(lastGroup, (Object)group)) {
                new ToolItem(this.toolbar, 2);
            }
            first = false;
            lastGroup = group;
            if (action.getType() == SapphireActionType.PUSH) {
                toolItem = new ToolItem(this.toolbar, 8);
                this.registerHotSpot(action, new ToolItemHotSpot(toolItem));
                toolItemListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        List<SapphireActionHandler> handlers = action.getActiveHandlers();
                        if (handlers.size() == 1) {
                            handlers.get(0).execute(context);
                        } else {
                            SapphireToolBarActionPresentation.this.displayActionHandlerChoice(action);
                        }
                    }
                };
            } else if (action.getType() == SapphireActionType.TOGGLE) {
                toolItem = new ToolItem(this.toolbar, 32);
                toolItemListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        action.getActiveHandlers().get(0).execute(context);
                    }
                };
            } else {
                throw new IllegalStateException();
            }
            final String hint = action.getRenderingHint("style", "image");
            if ("image".equals(hint) || "image+text".equals(hint)) {
                if (action.getImage(16) != null) {
                    toolItem.setImage(context.resources().image(action.getImage(16)));
                } else {
                    toolItem.setImage(DefaultActionImage.getDefaultActionImage());
                }
            }
            toolItem.setData((Object)action);
            toolItem.addSelectionListener((SelectionListener)toolItemListener);
            final Runnable updateActionLabelOp = new Runnable(){

                @Override
                public void run() {
                    if (Display.getCurrent() == null) {
                        Display.getDefault().asyncExec((Runnable)this);
                        return;
                    }
                    if (!toolItem.isDisposed() && ("image+text".equals(hint) || "text".equals(hint))) {
                        toolItem.setText(LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true));
                    }
                }
            };
            final Runnable updateActionToolTipOp = new Runnable(){

                @Override
                public void run() {
                    if (Display.getCurrent() == null) {
                        Display.getDefault().asyncExec((Runnable)this);
                        return;
                    }
                    if (!toolItem.isDisposed()) {
                        toolItem.setToolTipText(LabelTransformer.transform((String)action.getToolTip(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
                    }
                }
            };
            final Runnable updateActionEnablementStateOp = new Runnable(){

                @Override
                public void run() {
                    if (Display.getCurrent() == null) {
                        Display.getDefault().asyncExec((Runnable)this);
                        return;
                    }
                    if (!toolItem.isDisposed()) {
                        toolItem.setEnabled(action.isEnabled());
                    }
                }
            };
            final Runnable updateActionCheckedStateOp = new Runnable(){

                @Override
                public void run() {
                    if (Display.getCurrent() == null) {
                        Display.getDefault().asyncExec((Runnable)this);
                        return;
                    }
                    if (!toolItem.isDisposed()) {
                        toolItem.setSelection(action.isChecked());
                    }
                }
            };
            Listener listener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphireActionSystemPart.LabelChangedEvent) {
                        updateActionLabelOp.run();
                    } else if (event instanceof SapphireActionSystemPart.ToolTipChangedEvent) {
                        updateActionToolTipOp.run();
                    } else if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                        updateActionEnablementStateOp.run();
                    } else if (event instanceof SapphireActionSystemPart.CheckedStateChangedEvent) {
                        updateActionCheckedStateOp.run();
                    }
                }
            };
            action.attach(listener);
            this.listeners.put(action, listener);
            updateActionLabelOp.run();
            updateActionToolTipOp.run();
            updateActionEnablementStateOp.run();
            updateActionCheckedStateOp.run();
        }
        this.toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                int childId = event.childID;
                if (childId == -1) {
                    event.result = SapphireToolBarActionPresentation.this.getManager().getLabel();
                } else if (childId < SapphireToolBarActionPresentation.this.toolbar.getItemCount()) {
                    ToolItem item = SapphireToolBarActionPresentation.this.toolbar.getItem(childId);
                    SapphireAction action = (SapphireAction)item.getData();
                    event.result = LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
                }
            }
        });
    }

    @Override
    public void dispose() {
        if (this.listeners != null) {
            for (Map.Entry<SapphireAction, Listener> entry : this.listeners.entrySet()) {
                entry.getKey().detach(entry.getValue());
            }
        }
        super.dispose();
    }

    private static final class ToolItemHotSpot
    extends SapphireHotSpotsActionPresentation.HotSpot {
        private final ToolItem item;

        public ToolItemHotSpot(ToolItem item) {
            this.item = item;
        }

        @Override
        public Rectangle getBounds() {
            return this.toDisplay((Control)this.item.getParent(), this.item.getBounds());
        }
    }
}

