/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

public abstract class EqualsFactory {
    private static EqualsFactory TRUE = new TrueEqualsFactory();
    private static EqualsFactory FALSE = new FalseEqualsFactory();

    private EqualsFactory() {
    }

    public static EqualsFactory start() {
        return TRUE;
    }

    public abstract EqualsFactory add(Object var1, Object var2);

    public abstract EqualsFactory add(boolean var1, boolean var2);

    public abstract EqualsFactory add(char var1, char var2);

    public abstract EqualsFactory add(byte var1, byte var2);

    public abstract EqualsFactory add(short var1, short var2);

    public abstract EqualsFactory add(int var1, int var2);

    public abstract EqualsFactory add(long var1, long var3);

    public abstract EqualsFactory add(float var1, float var2);

    public abstract EqualsFactory add(double var1, double var3);

    public abstract boolean result();

    /* synthetic */ EqualsFactory(EqualsFactory equalsFactory) {
        this();
    }

    private static final class FalseEqualsFactory
    extends EqualsFactory {
        private FalseEqualsFactory() {
            super(null);
        }

        @Override
        public EqualsFactory add(Object x, Object y) {
            return this;
        }

        @Override
        public EqualsFactory add(boolean x, boolean y) {
            return this;
        }

        @Override
        public EqualsFactory add(char x, char y) {
            return this;
        }

        @Override
        public EqualsFactory add(byte x, byte y) {
            return this;
        }

        @Override
        public EqualsFactory add(short x, short y) {
            return this;
        }

        @Override
        public EqualsFactory add(int x, int y) {
            return this;
        }

        @Override
        public EqualsFactory add(long x, long y) {
            return this;
        }

        @Override
        public EqualsFactory add(float x, float y) {
            return this;
        }

        @Override
        public EqualsFactory add(double x, double y) {
            return this;
        }

        @Override
        public boolean result() {
            return false;
        }
    }

    private static final class TrueEqualsFactory
    extends EqualsFactory {
        private TrueEqualsFactory() {
            super(null);
        }

        @Override
        public EqualsFactory add(Object x, Object y) {
            if (x == y) {
                return TRUE;
            }
            if (x != null && y != null) {
                return x.equals(y) ? TRUE : FALSE;
            }
            return FALSE;
        }

        @Override
        public EqualsFactory add(boolean x, boolean y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public EqualsFactory add(char x, char y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public EqualsFactory add(byte x, byte y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public EqualsFactory add(short x, short y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public EqualsFactory add(int x, int y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public EqualsFactory add(long x, long y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public EqualsFactory add(float x, float y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public EqualsFactory add(double x, double y) {
            return x == y ? TRUE : FALSE;
        }

        @Override
        public boolean result() {
            return true;
        }
    }
}

