/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class PossibleValuesValidationService
extends ValidationService {
    private PossibleValuesService possibleValuesService;
    private Listener possibleValuesServiceListener;

    @Override
    protected void initValidationService() {
        this.possibleValuesService = this.context(Property.class).service(PossibleValuesService.class);
        this.possibleValuesServiceListener = new Listener(){

            @Override
            public void handle(Event event) {
                PossibleValuesValidationService.this.refresh();
            }
        };
        this.possibleValuesService.attach(this.possibleValuesServiceListener);
    }

    @Override
    protected Status compute() {
        Value value = this.context(Value.class);
        String text = value.text();
        if (text != null && !this.possibleValuesService.values().contains(text)) {
            return this.possibleValuesService.problem(value);
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.possibleValuesServiceListener != null) {
            this.possibleValuesService.detach(this.possibleValuesServiceListener);
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Value value = context.find(Value.class);
            return value != null && value.service(PossibleValuesService.class) != null && value.service(ReferenceService.class) == null;
        }
    }
}

