/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ModelRelativePath;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ModelRelativePathService
extends RelativePathService {
    @Override
    public List<Path> roots() {
        File file = this.context(Element.class).adapt(File.class);
        if (file == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Path(file.getParent()));
    }

    @Override
    public boolean enclosed() {
        return false;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && Path.class.isAssignableFrom(property.getTypeClass()) && property.hasAnnotation(ModelRelativePath.class);
        }
    }
}

