/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.MapFactory;

public abstract class ModelMetadataItem {
    private List<Annotation> annotations;
    private Map<Class<? extends Annotation>, Annotation> annotationByType;

    public ModelMetadataItem getBase() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAnnotations() {
        ModelMetadataItem modelMetadataItem = this;
        synchronized (modelMetadataItem) {
            if (this.annotations == null) {
                ListFactory<Annotation> annotationsListFactory = ListFactory.start();
                this.initAnnotations(annotationsListFactory);
                this.annotations = annotationsListFactory.result();
                MapFactory<Class<? extends Annotation>, Annotation> annotationByTypeMapFactory = MapFactory.start();
                for (Annotation annotation : this.annotations) {
                    annotationByTypeMapFactory.add(annotation.annotationType(), annotation);
                }
                this.annotationByType = annotationByTypeMapFactory.result();
            }
        }
    }

    protected abstract void initAnnotations(ListFactory<Annotation> var1);

    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        A annotation = this.getAnnotation(type);
        return annotation == null ? Collections.emptyList() : Collections.singletonList(annotation);
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        this.initAnnotations();
        return (A)((Annotation)type.cast(this.annotationByType.get(type)));
    }

    public final boolean hasAnnotation(Class<? extends Annotation> type) {
        return this.getAnnotation(type) != null;
    }

    public final String getLabel(boolean longLabel, CapitalizationType capitalizationType, boolean includeMnemonic) {
        String labelText = null;
        Label labelAnnotation = this.getAnnotation(Label.class);
        if (labelAnnotation != null) {
            if (longLabel) {
                labelText = labelAnnotation.full().trim();
            }
            if (labelText == null || labelText.length() == 0) {
                labelText = labelAnnotation.standard().trim();
            }
        }
        boolean transformNeeded = true;
        if (labelText == null) {
            ModelMetadataItem base = this.getBase();
            if (base != null) {
                labelText = base.getLabel(longLabel, capitalizationType, includeMnemonic);
                transformNeeded = false;
            } else {
                labelText = this.getDefaultLabel();
            }
        }
        if (transformNeeded) {
            labelText = this.getLocalizationService().text(labelText, capitalizationType, includeMnemonic);
        }
        return labelText;
    }

    protected abstract String getDefaultLabel();

    public abstract LocalizationService getLocalizationService();
}

