/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.Observable;

public final class ObservableSet<E>
implements Set<E>,
Observable {
    private final Set<E> base;
    private ListenerContext listeners;

    public ObservableSet() {
        this(null);
    }

    public ObservableSet(Set<E> base) {
        this.base = base == null ? new HashSet() : base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            if (this.listeners == null) {
                this.listeners = new ListenerContext();
            }
            this.listeners.attach(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            if (this.listeners != null) {
                this.listeners.detach(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast() {
        ListenerContext listeners;
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            listeners = this.listeners;
        }
        if (listeners != null) {
            listeners.broadcast(new Event());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            return this.base.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            return this.base.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object obj) {
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            return this.base.contains(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            return this.base.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            return new Iterator<E>(){
                private final Iterator<E> base;
                {
                    this.base = ObservableSet.this.base.iterator();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ObservableSet observableSet = ObservableSet.this;
                    synchronized (observableSet) {
                        return this.base.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public E next() {
                    ObservableSet observableSet = ObservableSet.this;
                    synchronized (observableSet) {
                        return this.base.next();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void remove() {
                    ObservableSet observableSet = ObservableSet.this;
                    synchronized (observableSet) {
                        this.base.remove();
                        ObservableSet.this.broadcast();
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            return this.base.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] array) {
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            return this.base.toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E entry) {
        boolean modified;
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            modified = this.base.add(entry);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean modified;
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            modified = this.base.addAll(collection);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object obj) {
        boolean modified;
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            modified = this.base.remove(obj);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified;
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            modified = this.base.removeAll(collection);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified;
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            modified = this.base.retainAll(collection);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        boolean broadcast = false;
        ObservableSet observableSet = this;
        synchronized (observableSet) {
            if (!this.base.isEmpty()) {
                broadcast = true;
            }
            this.base.clear();
        }
        if (broadcast) {
            this.broadcast();
        }
    }
}

