/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.sapphire.Result;
import org.eclipse.sapphire.modeling.BinaryData;

public final class ImageData
extends BinaryData {
    public ImageData(InputStream stream) throws IOException {
        super(stream);
    }

    public ImageData(byte[] data) {
        super(data);
    }

    /*
     * Loose catch block
     */
    public static Result<ImageData> readFromStream(InputStream stream) {
        Result<ImageData> result = Result.success(new ImageData(stream));
        try {
            stream.close();
        }
        catch (Exception exception) {}
        return result;
        catch (IOException e) {
            Result<ImageData> result2;
            try {
                result2 = Result.failure(new IllegalArgumentException(e));
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Exception exception) {}
            return result2;
        }
    }

    public static Result<ImageData> readFromUrl(URL url) {
        try {
            return ImageData.readFromStream(url.openStream());
        }
        catch (IOException e) {
            return Result.failure(new IllegalArgumentException(e));
        }
    }

    public static Result<ImageData> readFromClassLoader(Class<?> cl, String path) {
        String possibleFullPath;
        ImageData img;
        String pn;
        Package p;
        ClassLoader classloader = cl.getClassLoader();
        if (!path.contains("/") && (p = cl.getPackage()) != null && (pn = p.getName()) != null && pn.length() > 0 && (img = ImageData.readFromClassLoader(classloader, possibleFullPath = String.valueOf(pn.replace('.', '/')) + "/" + path).optional()) != null) {
            return Result.success(img);
        }
        return ImageData.readFromClassLoader(classloader, path);
    }

    public static Result<ImageData> readFromClassLoader(ClassLoader cl, String path) {
        URL url = cl.getResource(path);
        if (url != null) {
            return ImageData.readFromUrl(url);
        }
        return Result.failure(new IllegalArgumentException());
    }
}

