/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.util;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;

public class RepositoryUrlValidator {
    public static IStatus isValidUri(String repositoryUri) {
        URIish urish;
        try {
            urish = new URIish(repositoryUri);
        }
        catch (URISyntaxException e) {
            return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", e.getLocalizedMessage(), (Throwable)e);
        }
        if (urish.getScheme() == null) {
            return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_ABSOLUTE_URL_REQUIRED, repositoryUri));
        }
        boolean isSupportedScheme = false;
        for (TransportProtocol protocol : Transport.getTransportProtocols()) {
            if (!protocol.getSchemes().contains(urish.getScheme())) continue;
            for (TransportProtocol.URIishField requieredField : protocol.getRequiredFields()) {
                switch (requieredField) {
                    case USER: {
                        if (!StringUtils.isEmptyOrNull((String)urish.getUser())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_MISSING_COMPONENT_USER);
                    }
                    case PASS: {
                        if (!StringUtils.isEmptyOrNull((String)urish.getPass())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_MISSING_COMPONENT_PASSWORD);
                    }
                    case HOST: {
                        if (!StringUtils.isEmptyOrNull((String)urish.getHost())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_MISSING_COMPONENT_HOST);
                    }
                    case PATH: {
                        if (!StringUtils.isEmptyOrNull((String)urish.getPath())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_MISSING_COMPONENT_PATH);
                    }
                    case PORT: {
                        if (urish.getPort() > 0) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_MISSING_COMPONENT_PORT);
                    }
                }
            }
            EnumSet validFields = EnumSet.copyOf(protocol.getRequiredFields());
            validFields.addAll(protocol.getOptionalFields());
            for (TransportProtocol.URIishField invalidField : EnumSet.complementOf(validFields)) {
                switch (invalidField) {
                    case HOST: {
                        if (StringUtils.isEmptyOrNull((String)urish.getHost())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_COMPONENT_HOST);
                    }
                    case PATH: {
                        if (StringUtils.isEmptyOrNull((String)urish.getPath())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_COMPONENT_PATH);
                    }
                    case USER: {
                        if (StringUtils.isEmptyOrNull((String)urish.getUser())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_COMPONENT_USER);
                    }
                    case PASS: {
                        if (StringUtils.isEmptyOrNull((String)urish.getPass())) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_COMPONENT_PASSWORD);
                    }
                    case PORT: {
                        if (urish.getPort() < 0) break;
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_COMPONENT_PORT);
                    }
                }
            }
            isSupportedScheme = true;
            break;
        }
        if (!isSupportedScheme) {
            return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_URL_PROTOCOL_UNSUPPORTED, urish.getScheme(), StringUtils.join(RepositoryUrlValidator.getSupportedSchemes(), (String)Messages.LIST_SEPARATOR)));
        }
        return Status.OK_STATUS;
    }

    private static SortedSet<String> getSupportedSchemes() {
        TreeSet<String> supportedSchemes = new TreeSet<String>();
        for (TransportProtocol protocol : Transport.getTransportProtocols()) {
            supportedSchemes.addAll(protocol.getSchemes());
        }
        return supportedSchemes;
    }
}

