/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.completion;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ContextLoadingProposal
extends Job
implements ICompletionProposal,
ICompletionProposalExtension {
    private final IProjectCoordinateProvider pcProvider;
    private final Set<DependencyInfo> dependencies;
    private final Image image;
    private boolean resolutionJobDone = false;

    public ContextLoadingProposal(IProjectCoordinateProvider pcProvider, Set<DependencyInfo> dependencies, Image image) {
        super(Messages.JOB_NAME_IDENTIFYING_PROJECT_DEPENDENCIES);
        this.pcProvider = pcProvider;
        this.dependencies = dependencies;
        this.image = image;
    }

    protected IStatus run(IProgressMonitor monitor) {
        for (DependencyInfo dependencyInfo : this.dependencies) {
            this.pcProvider.resolve(dependencyInfo);
        }
        this.resolutionJobDone = true;
        return Status.OK_STATUS;
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return -1;
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getDisplayString() {
        return Messages.PROPOSAL_LABEL_IDENTIFYING_PROJECT_DEPENDENCIES;
    }

    public String getAdditionalProposalInfo() {
        return Messages.PROPOSAL_INFO_IDENTIFYING_PROJECT_DEPENDENCIES;
    }

    public Image getImage() {
        return this.image;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean isStillLoading() {
        return !this.resolutionJobDone;
    }
}

