/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPFullPathLabelProvider
extends LabelProvider
implements ILabelDecorator {
    private Image fInterfaceImage = PHPPluginImages.get("org.eclipse.php.ui.phpinterfacedata.png");
    private Image fClassImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.png");
    private Image fTraitImage = PHPPluginImages.get("org.eclipse.php.ui.trait_obj.png");
    private Image fMethodImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methpub_obj.png");

    public String getText(Object element) {
        if (element != null) {
            IType sourceElement;
            String elementName = "";
            String fileName = "";
            if (element instanceof DLTKSearchTypeNameMatch) {
                DLTKSearchTypeNameMatch typeMatch = (DLTKSearchTypeNameMatch)element;
                IType type = typeMatch.getType();
                elementName = type.getElementName();
                fileName = this.getFullName(type.getSourceModule());
            } else if (element instanceof IType) {
                sourceElement = (IType)element;
                elementName = sourceElement.getElementName();
                fileName = this.getFullName(sourceElement.getSourceModule());
            } else if (element instanceof IMember) {
                sourceElement = (IMember)element;
                elementName = sourceElement.getElementName();
                fileName = this.getFullName(sourceElement.getSourceModule());
            }
            StringBuilder result = new StringBuilder(elementName);
            result.append(" - ");
            result.append(fileName);
            return result.toString();
        }
        return "";
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element != null) {
            IType type = null;
            if (element instanceof DLTKSearchTypeNameMatch) {
                DLTKSearchTypeNameMatch typeMatch = (DLTKSearchTypeNameMatch)element;
                type = typeMatch.getType();
            }
            if (element instanceof IType) {
                type = (IType)element;
            }
            if (type != null) {
                try {
                    if (PHPFlags.isClass((int)type.getFlags())) {
                        result = this.fClassImage;
                    } else if (PHPFlags.isInterface((int)type.getFlags())) {
                        result = this.fInterfaceImage;
                    } else if (PHPFlags.isTrait((int)type.getFlags())) {
                        result = this.fTraitImage;
                    }
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
            if (element instanceof IMethod) {
                result = this.fMethodImage;
            }
        }
        return result;
    }

    private String getFullName(ISourceModule sourceModule) {
        Object path = null;
        path = sourceModule.getParent() instanceof ScriptFolder ? new Path(sourceModule.getParent().getElementName()).append((IPath)new Path(sourceModule.getElementName())) : new Path(sourceModule.getElementName());
        return path.toString();
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }
}

