/*******************************************************************************
 * Copyright (c) 2004, 2010 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.client.ui.rcp.handlers.open;

import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;

/**
 * Handler to open the SpecTestCaseEditor.
 * 
 * @author BREDEX GmbH
 * @created 05.09.2005
 */
public class OpenTestCaseEditorHandler extends AbstractOpenEditorHandler {
    /** {@inheritDoc} */
    protected boolean isEditableImpl(INodePO selected) {
        return selected instanceof ISpecTestCasePO
                && NodeBP.isEditable(selected);
    }
}