/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.s3;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.lfs.server.internal.LfsServerText;
import org.eclipse.jgit.lfs.server.s3.S3Config;
import org.eclipse.jgit.lib.Constants;

class SignerV4 {
    static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final String ALGORITHM = "HMAC-SHA256";
    private static final String DATE_STRING_FORMAT = "yyyyMMdd";
    private static final String HEX = "0123456789abcdef";
    private static final String HMACSHA256 = "HmacSHA256";
    private static final String ISO8601_BASIC_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String S3 = "s3";
    private static final String SCHEME = "AWS4";
    private static final String TERMINATOR = "aws4_request";
    private static final String UTC = "UTC";
    private static final String X_AMZ_ALGORITHM = "X-Amz-Algorithm";
    private static final String X_AMZ_CREDENTIAL = "X-Amz-Credential";
    private static final String X_AMZ_DATE = "X-Amz-Date";
    private static final String X_AMZ_SIGNATURE = "X-Amz-Signature";
    private static final String X_AMZ_SIGNED_HEADERS = "X-Amz-SignedHeaders";
    static final String X_AMZ_CONTENT_SHA256 = "x-amz-content-sha256";
    static final String X_AMZ_EXPIRES = "X-Amz-Expires";
    static final String X_AMZ_STORAGE_CLASS = "x-amz-storage-class";

    SignerV4() {
    }

    static String createAuthorizationQuery(S3Config bucketConfig, URL url, String httpMethod, Map<String, String> headers, Map<String, String> queryParameters, String bodyHash) {
        SignerV4.addHostHeader(url, headers);
        queryParameters.put(X_AMZ_ALGORITHM, "AWS4-HMAC-SHA256");
        Date now = new Date();
        String dateStamp = SignerV4.dateStamp(now);
        String scope = SignerV4.scope(bucketConfig.getRegion(), dateStamp);
        queryParameters.put(X_AMZ_CREDENTIAL, String.valueOf(bucketConfig.getAccessKey()) + "/" + scope);
        String dateTimeStampISO8601 = SignerV4.dateTimeStampISO8601(now);
        queryParameters.put(X_AMZ_DATE, dateTimeStampISO8601);
        String canonicalizedHeaderNames = SignerV4.canonicalizeHeaderNames(headers);
        queryParameters.put(X_AMZ_SIGNED_HEADERS, canonicalizedHeaderNames);
        String canonicalizedQueryParameters = SignerV4.canonicalizeQueryString(queryParameters);
        String canonicalizedHeaders = SignerV4.canonicalizeHeaderString(headers);
        String canonicalRequest = SignerV4.canonicalRequest(url, httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        byte[] signature = SignerV4.createSignature(bucketConfig, dateTimeStampISO8601, dateStamp, scope, canonicalRequest);
        queryParameters.put(X_AMZ_SIGNATURE, SignerV4.toHex(signature));
        return SignerV4.formatAuthorizationQuery(queryParameters);
    }

    private static String formatAuthorizationQuery(Map<String, String> queryParameters) {
        StringBuilder s = new StringBuilder();
        for (String key : queryParameters.keySet()) {
            SignerV4.appendQuery(s, key, queryParameters.get(key));
        }
        return s.toString();
    }

    private static void appendQuery(StringBuilder s, String key, String value) {
        if (s.length() != 0) {
            s.append("&");
        }
        s.append(key).append("=").append(value);
    }

    static Map<String, String> createHeaderAuthorization(S3Config bucketConfig, URL url, String httpMethod, Map<String, String> headers, String bodyHash) {
        SignerV4.addHostHeader(url, headers);
        Date now = new Date();
        String dateTimeStamp = SignerV4.dateTimeStampISO8601(now);
        headers.put(X_AMZ_DATE, dateTimeStamp);
        String canonicalizedHeaderNames = SignerV4.canonicalizeHeaderNames(headers);
        String canonicalizedHeaders = SignerV4.canonicalizeHeaderString(headers);
        String canonicalRequest = SignerV4.canonicalRequest(url, httpMethod, "", canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String dateStamp = SignerV4.dateStamp(now);
        String scope = SignerV4.scope(bucketConfig.getRegion(), dateStamp);
        byte[] signature = SignerV4.createSignature(bucketConfig, dateTimeStamp, dateStamp, scope, canonicalRequest);
        headers.put("Authorization", SignerV4.formatAuthorizationHeader(bucketConfig, canonicalizedHeaderNames, scope, signature));
        return headers;
    }

    private static String formatAuthorizationHeader(S3Config bucketConfig, String canonicalizedHeaderNames, String scope, byte[] signature) {
        StringBuilder s = new StringBuilder();
        s.append(SCHEME).append("-").append(ALGORITHM).append(" ");
        s.append("Credential=").append(bucketConfig.getAccessKey()).append("/").append(scope).append(",");
        s.append("SignedHeaders=").append(canonicalizedHeaderNames).append(",");
        s.append("Signature=").append(SignerV4.toHex(signature));
        return s.toString();
    }

    private static void addHostHeader(URL url, Map<String, String> headers) {
        StringBuilder hostHeader = new StringBuilder(url.getHost());
        int port = url.getPort();
        if (port > -1) {
            hostHeader.append(":").append(port);
        }
        headers.put("Host", hostHeader.toString());
    }

    private static String canonicalizeHeaderNames(Map<String, String> headers) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(headers.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(header.toLowerCase(Locale.ROOT));
        }
        return buffer.toString();
    }

    private static String canonicalizeHeaderString(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return "";
        }
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(headers.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String key : sortedHeaders) {
            buffer.append(String.valueOf(key.toLowerCase(Locale.ROOT).replaceAll("\\s+", " ")) + ":" + headers.get(key).replaceAll("\\s+", " "));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String dateStamp(Date now) {
        SimpleDateFormat dateStampFormat = new SimpleDateFormat(DATE_STRING_FORMAT);
        dateStampFormat.setTimeZone(new SimpleTimeZone(0, UTC));
        String dateStamp = dateStampFormat.format(now);
        return dateStamp;
    }

    private static String dateTimeStampISO8601(Date now) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(ISO8601_BASIC_FORMAT);
        dateTimeFormat.setTimeZone(new SimpleTimeZone(0, UTC));
        String dateTimeStamp = dateTimeFormat.format(now);
        return dateTimeStamp;
    }

    private static String scope(String region, String dateStamp) {
        String scope = String.format("%s/%s/%s/%s", dateStamp, region, S3, TERMINATOR);
        return scope;
    }

    private static String canonicalizeQueryString(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<String, String> pair : parameters.entrySet()) {
            String key = pair.getKey();
            String value = pair.getValue();
            sorted.put(SignerV4.urlEncode(key, false), SignerV4.urlEncode(value, false));
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            builder.append(pair.getKey());
            builder.append("=");
            builder.append(pair.getValue());
            if (!pairs.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    private static String canonicalRequest(URL endpoint, String httpMethod, String queryParameters, String canonicalizedHeaderNames, String canonicalizedHeaders, String bodyHash) {
        return String.format("%s\n%s\n%s\n%s\n%s\n%s", httpMethod, SignerV4.canonicalizeResourcePath(endpoint), queryParameters, canonicalizedHeaders, canonicalizedHeaderNames, bodyHash);
    }

    private static String canonicalizeResourcePath(URL endpoint) {
        if (endpoint == null) {
            return "/";
        }
        String path = endpoint.getPath();
        if (path == null || path.isEmpty()) {
            return "/";
        }
        String encodedPath = SignerV4.urlEncode(path, true);
        if (encodedPath.startsWith("/")) {
            return encodedPath;
        }
        return "/" + encodedPath;
    }

    private static byte[] hash(String s) {
        MessageDigest md = org.eclipse.jgit.lfs.lib.Constants.newMessageDigest();
        md.update(s.getBytes(Constants.CHARSET));
        return md.digest();
    }

    private static byte[] sign(String stringData, byte[] key) {
        try {
            byte[] data = stringData.getBytes(Constants.CHARSET);
            Mac mac = Mac.getInstance(HMACSHA256);
            mac.init(new SecretKeySpec(key, HMACSHA256));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormat.format(LfsServerText.get().failedToCalcSignature, e.getMessage()), e);
        }
    }

    private static String stringToSign(String scheme, String algorithm, String dateTime, String scope, String canonicalRequest) {
        return String.format("%s-%s\n%s\n%s\n%s", scheme, algorithm, dateTime, scope, SignerV4.toHex(SignerV4.hash(canonicalRequest)));
    }

    private static String toHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(2 * bytes.length);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(HEX.charAt((b & 0xF0) >> 4));
            builder.append(HEX.charAt(b & 0xF));
            ++n2;
        }
        return builder.toString();
    }

    private static String urlEncode(String url, boolean keepPathSlash) {
        String encoded;
        try {
            encoded = URLEncoder.encode(url, Constants.CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(LfsServerText.get().unsupportedUtf8, e);
        }
        if (keepPathSlash) {
            encoded = encoded.replace("%2F", "/");
        }
        return encoded;
    }

    private static byte[] createSignature(S3Config bucketConfig, String dateTimeStamp, String dateStamp, String scope, String canonicalRequest) {
        String stringToSign = SignerV4.stringToSign(SCHEME, ALGORITHM, dateTimeStamp, scope, canonicalRequest);
        byte[] signature = (SCHEME + bucketConfig.getSecretKey()).getBytes();
        signature = SignerV4.sign(dateStamp, signature);
        signature = SignerV4.sign(bucketConfig.getRegion(), signature);
        signature = SignerV4.sign(S3, signature);
        signature = SignerV4.sign(TERMINATOR, signature);
        signature = SignerV4.sign(stringToSign, signature);
        return signature;
    }
}

