/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.variables;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GitVariableResolver
implements IDynamicVariableResolver {
    private static final String GIT_REPO_RELATIVE_PATH = "git_repo_relative_path";
    private static final String GIT_DIR = "git_dir";
    private static final String GIT_WORK_TREE = "git_work_tree";
    private static final String GIT_BRANCH = "git_branch";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        if (variable.getName().equals(GIT_DIR)) {
            return this.getGitDir(argument);
        }
        if (variable.getName().equals(GIT_REPO_RELATIVE_PATH)) {
            return this.getGitRepoRelativePath(argument);
        }
        if (variable.getName().equals(GIT_WORK_TREE)) {
            return this.getGitWorkTree(argument);
        }
        if (variable.getName().equals(GIT_BRANCH)) {
            return this.getGitBranch(argument);
        }
        throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), UIText.GitVariableResolver_InternalError));
    }

    private String getGitRepoRelativePath(String argument) throws CoreException {
        IResource res = this.getResource(argument);
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)res);
        if (mapping != null) {
            String repoRelativePath = mapping.getRepoRelativePath(res);
            if (repoRelativePath == null) {
                return "";
            }
            if (repoRelativePath.equals("")) {
                return ".";
            }
            return repoRelativePath;
        }
        return "";
    }

    private String getGitDir(String argument) throws CoreException {
        IResource res = this.getResource(argument);
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)res);
        if (mapping != null) {
            return mapping.getRepository().getDirectory().getAbsolutePath();
        }
        return "";
    }

    @NonNull
    private String getGitWorkTree(String argument) throws CoreException {
        File workTree;
        IResource res = this.getResource(argument);
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)res);
        if (mapping != null && (workTree = mapping.getWorkTree()) != null) {
            return workTree.getAbsolutePath();
        }
        return "";
    }

    private String getGitBranch(String argument) throws CoreException {
        IResource res = this.getResource(argument);
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)res);
        if (mapping != null) {
            try {
                return mapping.getRepository().getBranch();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage()));
            }
        }
        return "";
    }

    @NonNull
    private IResource getResource(String argument) throws CoreException {
        IResource res;
        if (argument == null) {
            res = this.getResource();
            if (res == null) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), UIText.GitVariableResolver_NoSelectedResource));
            }
        } else {
            res = ResourcesPlugin.getWorkspace().getRoot().findMember(argument);
            if (res == null || !res.exists()) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), NLS.bind((String)UIText.GitVariableResolver_VariableReferencesNonExistentResource, (Object)argument)));
            }
        }
        return res;
    }

    private IResource getResource() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.getThread().equals(Thread.currentThread())) {
            return this.getSelectedResource();
        }
        final IResource[] resource = new IResource[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                resource[0] = GitVariableResolver.this.getSelectedResource();
            }
        });
        return resource[0];
    }

    private IResource getSelectedResource() {
        IWorkbenchPage page;
        IResource resource = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = null;
        if (workbench != null) {
            window = workbench.getActiveWorkbenchWindow();
        }
        if (window != null && (page = window.getActivePage()) != null) {
            IStructuredSelection ss;
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IEditorPart) {
                IEditorPart epart = (IEditorPart)part;
                resource = AdapterUtils.adaptToAnyResource((Object)epart.getEditorInput());
            } else if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Iterator iterator = ss.iterator();
                while (iterator.hasNext() && resource == null) {
                    Object next = iterator.next();
                    resource = AdapterUtils.adaptToAnyResource(next);
                }
            }
        }
        return resource;
    }
}

