/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.eclipse.wst.xsl.ui.provisional.contentassist.AbstractXSLContentAssistRequest;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateModeAttributeContentAssist
extends AbstractXSLContentAssistRequest {
    private static final String MODE_ATTRIBUTE = "mode";

    public TemplateModeAttributeContentAssist(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        super(node, documentRegion, completionRegion, begin, length, filter, textViewer);
    }

    @Override
    public ArrayList<ICompletionProposal> getCompletionProposals() {
        this.proposals.clear();
        StylesheetModel model = this.getStylesheetModel();
        this.addModeProposals(model);
        return this.getAllCompletionProposals();
    }

    protected void addModeProposals(StylesheetModel model) {
        List templates = model.getTemplates();
        ArrayList<String> modes = new ArrayList<String>();
        for (Template template : templates) {
            XSLAttribute attribute = template.getAttribute(MODE_ATTRIBUTE);
            IDOMNode xmlNode = (IDOMNode)this.node;
            if (attribute == null || xmlNode.getStartOffset() == template.getOffset()) continue;
            CustomCompletionProposal proposal = new CustomCompletionProposal(attribute.getValue(), this.getStartOffset() + 1, 0, attribute.getValue().length(), XSLPluginImageHelper.getInstance().getImage("icons/full/mode.gif"), attribute.getValue(), null, null, 0);
            if (modes.indexOf(attribute.getValue()) != -1) continue;
            this.proposals.add(proposal);
            modes.add(attribute.getValue());
        }
        modes.clear();
    }
}

