/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.websocket;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.internal.transport.AbstractSocketWrapper;
import org.eclipse.wst.jsdt.chromium.internal.websocket.AbstractWsConnection;

public class ManualLoggingSocketWrapper
extends AbstractSocketWrapper<LoggableInput, LoggableOutput> {
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    public static final FactoryBase PLAIN_ASCII = new FactoryBase(){

        public LoggableOutput wrapOutputStream(LoggableOutput originalOutputWrapper, ConnectionLogger.StreamListener streamListener) {
            return new FactoryBase.OutputWrapperBase(originalOutputWrapper, streamListener){

                @Override
                public void writeByteToLog(byte b) throws IOException {
                }

                @Override
                public void writeToLog(String string, String annotation) throws IOException {
                }

                @Override
                public void writeByteNoLogging(byte b) throws IOException {
                    this.getOriginalOutputWrapper().writeByteNoLogging(b);
                    ManualLoggingSocketWrapper.dumpByte(b, this.getStreamListener());
                }

                @Override
                public void writeBytesToLog(byte[] bytes) {
                }

                @Override
                public void writeBytesNoLogging(byte[] bytes) throws IOException {
                    this.getOriginalOutputWrapper().writeBytesNoLogging(bytes);
                    String str = new String(bytes, CHARSET);
                    this.getStreamListener().addContent((CharSequence)str);
                }
            };
        }
    };
    public static final FactoryBase ANNOTATED = new FactoryBase(){

        public LoggableOutput wrapOutputStream(LoggableOutput originalOutputWrapper, ConnectionLogger.StreamListener streamListener) {
            return new FactoryBase.OutputWrapperBase(originalOutputWrapper, streamListener){

                @Override
                public void writeByteToLog(byte b) throws IOException {
                    ManualLoggingSocketWrapper.dumpByte(b, this.getStreamListener());
                }

                @Override
                public void writeToLog(String string, String annotation) throws IOException {
                    this.getStreamListener().addContent((CharSequence)(String.valueOf(annotation) + "<" + string + ">"));
                }

                @Override
                public void writeBytesToLog(byte[] bytes) {
                    StringBuilder builder = new StringBuilder(bytes.length * 4);
                    byte[] byArray = bytes;
                    int n = bytes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        ManualLoggingSocketWrapper.dumpByte(b, builder);
                        ++n2;
                    }
                    this.getStreamListener().addContent((CharSequence)builder);
                }

                @Override
                public void writeByteNoLogging(byte b) throws IOException {
                    this.getOriginalOutputWrapper().writeByteNoLogging(b);
                }

                @Override
                public void writeBytesNoLogging(byte[] bytes) throws IOException {
                    this.getOriginalOutputWrapper().writeBytesNoLogging(bytes);
                }
            };
        }
    };

    public ManualLoggingSocketWrapper(SocketAddress endpoint, int connectionTimeoutMs, ConnectionLogger connectionLogger, AbstractSocketWrapper.WrapperFactory<LoggableInput, LoggableOutput> wrapperFactory) throws IOException {
        super(endpoint, connectionTimeoutMs, connectionLogger, wrapperFactory);
    }

    private static void dumpByte(byte b, StringBuilder output) {
        AbstractWsConnection.dumpByte(b, output);
    }

    private static void dumpByte(byte b, ConnectionLogger.StreamListener streamListener) {
        StringBuilder builder = new StringBuilder(4);
        ManualLoggingSocketWrapper.dumpByte(b, builder);
        streamListener.addContent((CharSequence)builder);
    }

    public static abstract class FactoryBase
    implements AbstractSocketWrapper.WrapperFactory<LoggableInput, LoggableOutput> {
        protected static final Charset CHARSET = AbstractWsConnection.LOGGER_CHARSET;

        public LoggableInput wrapInputStream(InputStream inputStream) {
            final BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            return new LoggableInput(){

                @Override
                public ByteBuffer readUpTo0x0D0A() throws IOException {
                    byte b;
                    ByteBuffer buffer = ByteBuffer.allocate(20);
                    while ((b = this.expectByte()) != 13) {
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            ByteBuffer biggerBuffer = ByteBuffer.allocate(buffer.remaining() * 2);
                            biggerBuffer.put(buffer);
                            buffer = biggerBuffer;
                        }
                        buffer.put(b);
                    }
                    byte b2 = this.expectByte();
                    if (b2 != 10) {
                        throw new IOException("0x0A byte expected");
                    }
                    buffer.flip();
                    return buffer;
                }

                @Override
                public int readByteOrEos() throws IOException {
                    return bufferedInputStream.read();
                }

                private byte expectByte() throws IOException {
                    int next = bufferedInputStream.read();
                    if (next == -1) {
                        throw new IOException("Unexpected EOS");
                    }
                    return (byte)next;
                }

                @Override
                public byte[] readBytes(int length) throws IOException {
                    byte[] result = new byte[length];
                    int offset = 0;
                    while (length > 0) {
                        int r = bufferedInputStream.read(result, offset, length);
                        if (r == -1) {
                            throw new IOException("Unexpected EOS");
                        }
                        length -= r;
                        offset += r;
                    }
                    return result;
                }

                @Override
                public void markSeparatorForLog() {
                }
            };
        }

        public LoggableOutput wrapOutputStream(final OutputStream outputStream) {
            return new LoggableOutput(){

                @Override
                public void writeAsciiString(String string) throws IOException {
                    outputStream.write(string.getBytes(UTF_8_CHARSET));
                }

                @Override
                public void writeByte(byte b) throws IOException {
                    outputStream.write(b);
                }

                @Override
                public void writeBytes(byte[] bytes) throws IOException {
                    outputStream.write(bytes);
                }

                @Override
                public void writeBytesToLog(byte[] bytes) {
                }

                @Override
                public void writeBytesNoLogging(byte[] bytes) throws IOException {
                    outputStream.write(bytes);
                }

                @Override
                public void writeToLog(String string, String annotation) throws IOException {
                }

                @Override
                public void writeByteNoLogging(byte b) throws IOException {
                    outputStream.write(b);
                }

                @Override
                public void writeByteToLog(byte b) throws IOException {
                }

                @Override
                public void markSeparatorForLog() {
                }
            };
        }

        public LoggableInput wrapInputStream(final LoggableInput originalInputWrapper, final ConnectionLogger.StreamListener streamListener) {
            return new LoggableInput(){

                @Override
                public ByteBuffer readUpTo0x0D0A() throws IOException {
                    ByteBuffer bytes = originalInputWrapper.readUpTo0x0D0A();
                    String logString = String.valueOf(new String(bytes.array(), bytes.arrayOffset(), bytes.limit(), CHARSET)) + "\r\n";
                    streamListener.addContent((CharSequence)logString);
                    return bytes;
                }

                @Override
                public byte[] readBytes(int length) throws IOException {
                    byte[] bytes = originalInputWrapper.readBytes(length);
                    String logString = new String(bytes, CHARSET);
                    streamListener.addContent((CharSequence)logString);
                    return bytes;
                }

                @Override
                public int readByteOrEos() throws IOException {
                    int res = originalInputWrapper.readByteOrEos();
                    if (res != -1) {
                        StringBuilder builder = new StringBuilder(4);
                        ManualLoggingSocketWrapper.dumpByte((byte)res, builder);
                        streamListener.addContent((CharSequence)builder);
                    }
                    return res;
                }

                @Override
                public void markSeparatorForLog() {
                    streamListener.addSeparator();
                }
            };
        }

        protected static abstract class OutputWrapperBase
        extends LoggableOutput {
            private final LoggableOutput originalOutputWrapper;
            private final ConnectionLogger.StreamListener streamListener;

            public OutputWrapperBase(LoggableOutput originalOutputWrapper, ConnectionLogger.StreamListener streamListener) {
                this.originalOutputWrapper = originalOutputWrapper;
                this.streamListener = streamListener;
            }

            @Override
            public void writeAsciiString(String string) throws IOException {
                this.originalOutputWrapper.writeAsciiString(string);
                this.streamListener.addContent((CharSequence)string);
            }

            @Override
            public void writeByte(byte b) throws IOException {
                this.originalOutputWrapper.writeByte(b);
                ManualLoggingSocketWrapper.dumpByte(b, this.getStreamListener());
            }

            @Override
            public void writeBytes(byte[] bytes) throws IOException {
                this.originalOutputWrapper.writeBytes(bytes);
                StringBuilder builder = new StringBuilder(bytes.length * 4);
                byte[] byArray = bytes;
                int n = bytes.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    ManualLoggingSocketWrapper.dumpByte(b, builder);
                    ++n2;
                }
                this.streamListener.addContent((CharSequence)builder);
            }

            @Override
            public void markSeparatorForLog() {
                this.streamListener.addSeparator();
            }

            protected LoggableOutput getOriginalOutputWrapper() {
                return this.originalOutputWrapper;
            }

            protected ConnectionLogger.StreamListener getStreamListener() {
                return this.streamListener;
            }
        }
    }

    public static abstract class LoggableInput {
        public abstract int readByteOrEos() throws IOException;

        public abstract byte[] readBytes(int var1) throws IOException;

        public abstract ByteBuffer readUpTo0x0D0A() throws IOException;

        public abstract void markSeparatorForLog();
    }

    public static abstract class LoggableOutput {
        public abstract void writeAsciiString(String var1) throws IOException;

        public abstract void writeByte(byte var1) throws IOException;

        public abstract void writeByteNoLogging(byte var1) throws IOException;

        public abstract void writeByteToLog(byte var1) throws IOException;

        public abstract void writeBytes(byte[] var1) throws IOException;

        public abstract void writeBytesToLog(byte[] var1);

        public abstract void writeBytesNoLogging(byte[] var1) throws IOException;

        public abstract void writeToLog(String var1, String var2) throws IOException;

        public abstract void markSeparatorForLog();
    }
}

