/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.grid;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.GenericPropertyGetValue;
import org.eclipse.wb.core.model.broadcast.GenericPropertySetValue;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.StaticFieldPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridImages;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.actions.ClearHintAction;
import org.eclipse.wb.internal.swt.model.layout.grid.actions.SetAlignmentAction;
import org.eclipse.wb.internal.swt.model.layout.grid.actions.SetGrabAction;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.support.GridLayoutSupport;

public final class GridDataInfo
extends LayoutDataInfo
implements IGridDataInfo {
    private boolean m_internalLocationChange = false;
    int x = -1;
    int y = -1;
    int width = 1;
    int height = 1;
    boolean horizontalGrab;
    boolean verticalGrab;
    int horizontalAlignment;
    int verticalAlignment;
    int widthHint;
    int heightHint;
    boolean exclude;

    public GridDataInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.useAccessorsForPropertyValues();
        this.contributeContextMenu();
        this.validateSpanPropertyValues();
    }

    private void useAccessorsForPropertyValues() {
        this.addBroadcastListener(new GenericPropertyGetValue(){

            public void invoke(GenericPropertyImpl property, Object[] value) throws Exception {
                if (property.getJavaInfo() == GridDataInfo.this) {
                    String title = property.getTitle();
                    if (title.equals("horizontalAlignment")) {
                        value[0] = GridDataInfo.this.getHorizontalAlignment();
                    }
                    if (title.equals("verticalAlignment")) {
                        value[0] = GridDataInfo.this.getVerticalAlignment();
                    }
                }
            }
        });
    }

    private void validateSpanPropertyValues() {
        this.addBroadcastListener(new GenericPropertySetValue(){

            public void invoke(GenericPropertyImpl property, Object[] value, boolean[] shouldSetValue) throws Exception {
                if (GridDataInfo.this.m_internalLocationChange) {
                    return;
                }
                if (property.getJavaInfo() == GridDataInfo.this && value[0] instanceof Integer) {
                    int span;
                    String title = property.getTitle();
                    if (title.equals("horizontalSpan") && !this.isValidHorizontalSpan(span = ((Integer)value[0]).intValue())) {
                        shouldSetValue[0] = false;
                        return;
                    }
                    if (title.equals("verticalSpan") && !this.isValidVerticalSpan(span = ((Integer)value[0]).intValue())) {
                        shouldSetValue[0] = false;
                        return;
                    }
                }
            }

            private boolean isValidHorizontalSpan(int span) throws Exception {
                if (span <= 0) {
                    return false;
                }
                IGridInfo grid = GridDataInfo.this.getLayout().getGridInfo();
                Rectangle cells = grid.getComponentCells((IAbstractComponentInfo)GridDataInfo.this.getControl());
                return cells.x + span <= grid.getColumnCount();
            }

            private boolean isValidVerticalSpan(int span) throws Exception {
                if (span <= 0) {
                    return false;
                }
                IGridInfo grid = GridDataInfo.this.getLayout().getGridInfo();
                Rectangle cells = grid.getComponentCells((IAbstractComponentInfo)GridDataInfo.this.getControl());
                return cells.y + span <= grid.getRowCount();
            }
        });
    }

    private void contributeContextMenu() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (GridDataInfo.this.getParent() == object) {
                    GridDataInfo.this.addContextMenu(manager);
                }
            }
        });
    }

    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        this.getCurrentObjectFields();
    }

    public boolean getExclude() {
        return this.exclude;
    }

    private void getCurrentObjectFields() throws Exception {
        Object controlObject;
        Object object = this.getObject();
        GridLayoutInfo layout = this.getLayout();
        if (layout == null) {
            return;
        }
        Object layoutObject = layout.getObject();
        Point xyPoint = GridLayoutSupport.getXY(layoutObject, controlObject = this.getControl().getObject());
        if (xyPoint != null) {
            this.x = xyPoint.x;
            this.y = xyPoint.y;
        }
        this.width = ReflectionUtils.getFieldInt((Object)object, (String)"horizontalSpan");
        this.height = ReflectionUtils.getFieldInt((Object)object, (String)"verticalSpan");
        this.horizontalGrab = ReflectionUtils.getFieldBoolean((Object)object, (String)"grabExcessHorizontalSpace");
        this.verticalGrab = ReflectionUtils.getFieldBoolean((Object)object, (String)"grabExcessVerticalSpace");
        this.horizontalAlignment = ReflectionUtils.getFieldInt((Object)object, (String)"horizontalAlignment");
        this.horizontalAlignment = this.getModernHorizontalAlignment(this.horizontalAlignment);
        this.verticalAlignment = ReflectionUtils.getFieldInt((Object)object, (String)"verticalAlignment");
        this.verticalAlignment = this.getModernVerticalAlignment(this.verticalAlignment);
        this.widthHint = ReflectionUtils.getFieldInt((Object)object, (String)"widthHint");
        this.heightHint = ReflectionUtils.getFieldInt((Object)object, (String)"heightHint");
        int numColumns = layout.getNumColumns();
        this.width = Math.max(1, Math.min(this.width, numColumns));
        this.exclude = ReflectionUtils.getFieldBoolean((Object)object, (String)"exclude");
    }

    private ControlInfo getControl() {
        return (ControlInfo)this.getParent();
    }

    private GridLayoutInfo getLayout() {
        CompositeInfo composite = (CompositeInfo)this.getControl().getParent();
        if (composite == null) {
            return null;
        }
        return (GridLayoutInfo)composite.getLayout();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setHorizontalSpan(int width) throws Exception {
        if (this.width != width) {
            this.width = width;
            this.m_internalLocationChange = true;
            try {
                this.getPropertyByTitle("horizontalSpan").setValue((Object)width);
            }
            finally {
                this.m_internalLocationChange = false;
            }
        }
    }

    public void setVerticalSpan(int height) throws Exception {
        if (this.height != height) {
            this.height = height;
            this.m_internalLocationChange = true;
            try {
                this.getPropertyByTitle("verticalSpan").setValue((Object)height);
            }
            finally {
                this.m_internalLocationChange = false;
            }
        }
    }

    public boolean getHorizontalGrab() {
        return this.horizontalGrab;
    }

    public void setHorizontalGrab(boolean grab) throws Exception {
        this.horizontalGrab = grab;
        this.getPropertyByTitle("grabExcessHorizontalSpace").setValue((Object)(grab ? Boolean.TRUE : Boolean.FALSE));
    }

    public boolean getVerticalGrab() {
        return this.verticalGrab;
    }

    public void setVerticalGrab(boolean grab) throws Exception {
        this.verticalGrab = grab;
        this.getPropertyByTitle("grabExcessVerticalSpace").setValue((Object)(grab ? Boolean.TRUE : Boolean.FALSE));
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) throws Exception {
        if (this.horizontalAlignment != (alignment = this.getModernHorizontalAlignment(alignment))) {
            this.horizontalAlignment = alignment;
            this.setEnumProperty("horizontalAlignment", this.horizontalAlignment);
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int alignment) throws Exception {
        if (this.verticalAlignment != (alignment = this.getModernVerticalAlignment(alignment))) {
            this.verticalAlignment = alignment;
            this.setEnumProperty("verticalAlignment", this.verticalAlignment);
        }
    }

    private int getModernHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 1: {
                return 16384;
            }
            case 2: {
                return 0x1000000;
            }
            case 3: 
            case 0x1000008: {
                return 131072;
            }
            case 4: {
                return 4;
            }
        }
        return alignment;
    }

    private int getModernVerticalAlignment(int alignment) {
        switch (alignment) {
            case 1: {
                return 128;
            }
            case 2: {
                return 0x1000000;
            }
            case 3: 
            case 0x1000008: {
                return 1024;
            }
            case 4: {
                return 4;
            }
        }
        return alignment;
    }

    public int getWidthHint() {
        return this.widthHint;
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    public void setWidthHint(int widthHint) throws Exception {
        if (this.widthHint != widthHint) {
            this.widthHint = widthHint;
            this.getPropertyByTitle("widthHint").setValue((Object)widthHint);
        }
    }

    public void setHeightHint(int heightHint) throws Exception {
        if (this.heightHint != heightHint) {
            this.heightHint = heightHint;
            this.getPropertyByTitle("heightHint").setValue((Object)heightHint);
        }
    }

    private void setEnumProperty(String propertyTitle, int value) throws Exception {
        Property property = this.getPropertyByTitle(propertyTitle);
        GridDataInfo.setEnumProperty(property, value);
    }

    private static void setEnumProperty(Property property, int value) throws Exception {
        StaticFieldPropertyEditor propertyEditor = (StaticFieldPropertyEditor)property.getEditor();
        propertyEditor.setValue(property, (Object)value);
    }

    public Image getSmallAlignmentImage(boolean horizontal) {
        if (horizontal) {
            switch (this.horizontalAlignment) {
                case 16384: {
                    return GridImages.getImage("h/left.gif");
                }
                case 0x1000000: {
                    return GridImages.getImage("h/center.gif");
                }
                case 131072: {
                    return GridImages.getImage("h/right.gif");
                }
                case 4: {
                    return GridImages.getImage("h/fill.gif");
                }
            }
            return null;
        }
        switch (this.verticalAlignment) {
            case 128: {
                return GridImages.getImage("v/top.gif");
            }
            case 0x1000000: {
                return GridImages.getImage("v/center.gif");
            }
            case 1024: {
                return GridImages.getImage("v/bottom.gif");
            }
            case 4: {
                return GridImages.getImage("v/fill.gif");
            }
        }
        return null;
    }

    public void addContextMenu(IMenuManager manager) {
        MenuManager manager2 = new MenuManager(ModelMessages.GridDataInfo_horizontalAlignment);
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        manager2.add((IAction)new SetGrabAction(this, ModelMessages.GridDataInfo_grabExcessSpace, "grow.gif", true));
        if (this.getWidthHint() != -1) {
            manager2.add((IAction)new ClearHintAction(this, ModelMessages.GridDataInfo_clearHint, true));
        }
        manager2.add((IContributionItem)new Separator());
        this.fillHorizontalAlignmentMenu((IMenuManager)manager2);
        manager2 = new MenuManager(ModelMessages.GridDataInfo_verticalAlignment);
        manager.appendToGroup("org.eclipse.wb.popup.group.top", (IContributionItem)manager2);
        manager2.add((IAction)new SetGrabAction(this, ModelMessages.GridDataInfo_grabExcessSpace, "grow.gif", false));
        if (this.getHeightHint() != -1) {
            manager2.add((IAction)new ClearHintAction(this, ModelMessages.GridDataInfo_clearHint, false));
        }
        manager2.add((IContributionItem)new Separator());
        this.fillVerticalAlignmentMenu((IMenuManager)manager2);
    }

    public void fillHorizontalAlignmentMenu(IMenuManager manager) {
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_horLeft, "left.gif", true, 16384));
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_horCenter, "center.gif", true, 0x1000000));
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_horRight, "right.gif", true, 131072));
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_horFill, "fill.gif", true, 4));
    }

    public void fillVerticalAlignmentMenu(IMenuManager manager) {
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_verTop, "top.gif", false, 128));
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_verCenter, "center.gif", false, 0x1000000));
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_verBottom, "bottom.gif", false, 1024));
        manager.add((IAction)new SetAlignmentAction((IGridDataInfo)this, ModelMessages.GridDataInfo_verFill, "fill.gif", false, 4));
    }
}

