/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.criticalpath;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.TmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathAlgorithmException;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathAlgorithm;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.CriticalPathAlgorithmBounded;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CriticalPathModule
extends TmfAbstractAnalysisModule
implements ICriticalPathProvider {
    public static final String ANALYSIS_ID = "org.eclipse.tracecompass.analysis.graph.core.criticalpath";
    @Deprecated
    public static final String PARAM_GRAPH = "graph";
    public static final String PARAM_WORKER = "workerid";
    private final @Nullable TmfGraphBuilderModule fGraphModule;
    private volatile @Nullable TmfGraph fCriticalPath;

    @Deprecated
    public CriticalPathModule() {
        this.addParameter(PARAM_WORKER);
        this.setId(ANALYSIS_ID);
        this.fGraphModule = null;
    }

    public CriticalPathModule(TmfGraphBuilderModule graph) {
        this.addParameter(PARAM_WORKER);
        this.setId(ANALYSIS_ID);
        this.fGraphModule = graph;
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        Object workerObj = this.getParameter(PARAM_WORKER);
        if (workerObj == null) {
            return false;
        }
        if (!(workerObj instanceof IGraphWorker)) {
            throw new IllegalStateException("Worker parameter must be an IGraphWorker");
        }
        IGraphWorker worker = (IGraphWorker)workerObj;
        TmfGraphBuilderModule graphModule = this.fGraphModule;
        if (graphModule == null) {
            Activator.getInstance().logWarning("No graph was found to execute the critical path on");
            return true;
        }
        graphModule.schedule();
        monitor.setTaskName(NLS.bind((String)Messages.CriticalPathModule_waitingForGraph, (Object)graphModule.getName()));
        if (!graphModule.waitForCompletion(monitor)) {
            Activator.getInstance().logInfo("Critical path execution: graph building was cancelled.  Results may not be accurate.");
            return false;
        }
        TmfGraph graph = graphModule.getGraph();
        if (graph == null) {
            throw new TmfAnalysisException("Critical Path analysis: graph " + graphModule.getName() + " is null");
        }
        TmfVertex head = graph.getHead(worker);
        if (head == null) {
            this.fCriticalPath = new TmfGraph();
            return true;
        }
        ICriticalPathAlgorithm cp = CriticalPathModule.getAlgorithm(graph);
        try {
            this.fCriticalPath = cp.compute(head, null);
            return true;
        }
        catch (CriticalPathAlgorithmException e) {
            Activator.getInstance().logError(NonNullUtils.nullToEmptyString((Object)e.getMessage()), (Throwable)e);
            return false;
        }
    }

    protected void canceling() {
    }

    protected void parameterChanged(String name) {
        this.fCriticalPath = null;
        this.cancel();
        this.resetAnalysis();
        this.schedule();
    }

    private static ICriticalPathAlgorithm getAlgorithm(TmfGraph graph) {
        return new CriticalPathAlgorithmBounded(graph);
    }

    public boolean canExecute(@NonNull ITmfTrace trace) {
        return true;
    }

    @Override
    public @Nullable TmfGraph getCriticalPath() {
        return this.fCriticalPath;
    }

    protected @NonNull String getFullHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.CriticalPathModule_fullHelpText);
    }

    protected @NonNull String getShortHelpText(ITmfTrace trace) {
        return this.getFullHelpText();
    }

    protected @NonNull String getTraceCannotExecuteHelpText(@NonNull ITmfTrace trace) {
        return NonNullUtils.nullToEmptyString((Object)Messages.CriticalPathModule_cantExecute);
    }
}

