/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.figure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.figure.RevisionFigure;
import org.eclipse.team.svn.ui.utility.DateFormatter;

public class RevisionTooltipFigure
extends Figure {
    public static final Image COMMENT_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/comment.gif").createImage();
    protected final RevisionNode revisionNode;
    protected Label pathText;
    protected Label authorText;
    protected Label dateText;
    protected Label copyText;
    protected Label incomingMergeText;
    protected Label outgoingMergeText;
    protected Label commentText;

    static {
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)COMMENT_IMAGE);
    }

    public RevisionTooltipFigure(RevisionNode revisionNode) {
        this.revisionNode = revisionNode;
        this.createControls();
        this.initControls();
        this.setBorder((Border)new LineBorder(ColorConstants.white));
    }

    protected void createControls() {
        ToolbarLayout parentLayout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)parentLayout);
        Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        Figure parent = new Figure();
        this.add((IFigure)parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        parent.setLayoutManager((LayoutManager)layout);
        this.pathText = new Label();
        parent.add((IFigure)this.pathText);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        layout.setConstraint((IFigure)this.pathText, (Object)data);
        this.pathText.setFont(boldFont);
        Figure blankFigure = new Figure();
        data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 5;
        layout.setConstraint((IFigure)blankFigure, (Object)data);
        parent.add((IFigure)blankFigure);
        Label authorLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_Author);
        parent.add((IFigure)authorLabel);
        data = new GridData();
        layout.setConstraint((IFigure)authorLabel, (Object)data);
        authorLabel.setFont(boldFont);
        this.authorText = new Label();
        parent.add((IFigure)this.authorText);
        layout.setConstraint((IFigure)this.authorText, (Object)new GridData());
        Label dateLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_Date);
        parent.add((IFigure)dateLabel);
        data = new GridData();
        layout.setConstraint((IFigure)dateLabel, (Object)data);
        dateLabel.setFont(boldFont);
        this.dateText = new Label();
        parent.add((IFigure)this.dateText);
        layout.setConstraint((IFigure)this.dateText, (Object)new GridData());
        if (this.revisionNode.getCopiedFrom() != null) {
            Label copyLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_CopiedFrom);
            parent.add((IFigure)copyLabel);
            data = new GridData();
            layout.setConstraint((IFigure)copyLabel, (Object)data);
            copyLabel.setFont(boldFont);
            this.copyText = new Label();
            parent.add((IFigure)this.copyText);
            layout.setConstraint((IFigure)this.copyText, (Object)new GridData());
        }
        if (this.revisionNode.hasIncomingMerges()) {
            blankFigure = new Figure();
            data = new GridData();
            data.horizontalSpan = 2;
            data.heightHint = 5;
            layout.setConstraint((IFigure)blankFigure, (Object)data);
            parent.add((IFigure)blankFigure);
            Label mergedFromLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_IncomingMerge);
            parent.add((IFigure)mergedFromLabel);
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            layout.setConstraint((IFigure)mergedFromLabel, (Object)data);
            mergedFromLabel.setFont(boldFont);
            this.incomingMergeText = new Label();
            parent.add((IFigure)this.incomingMergeText);
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            layout.setConstraint((IFigure)this.incomingMergeText, (Object)data);
        }
        if (this.revisionNode.hasOutgoingMerges()) {
            blankFigure = new Figure();
            data = new GridData();
            data.horizontalSpan = 2;
            data.heightHint = 5;
            layout.setConstraint((IFigure)blankFigure, (Object)data);
            parent.add((IFigure)blankFigure);
            Label mergedToLabel = new Label(SVNRevisionGraphMessages.RevisionTooltipFigure_OutgoingMerge);
            parent.add((IFigure)mergedToLabel);
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            layout.setConstraint((IFigure)mergedToLabel, (Object)data);
            mergedToLabel.setFont(boldFont);
            this.outgoingMergeText = new Label();
            parent.add((IFigure)this.outgoingMergeText);
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            layout.setConstraint((IFigure)this.outgoingMergeText, (Object)data);
        }
        blankFigure = new Figure();
        data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 5;
        layout.setConstraint((IFigure)blankFigure, (Object)data);
        parent.add((IFigure)blankFigure);
        blankFigure = new Figure();
        data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 5;
        layout.setConstraint((IFigure)blankFigure, (Object)data);
        parent.add((IFigure)blankFigure);
        Figure separator = new Figure(){

            public void paintFigure(Graphics graphics) {
                Rectangle rect = this.getClientArea();
                graphics.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            }
        };
        separator.setForegroundColor(ColorConstants.gray);
        data = new GridData(768);
        data.heightHint = 1;
        data.horizontalSpan = 2;
        layout.setConstraint((IFigure)separator, (Object)data);
        parent.add((IFigure)separator);
        blankFigure = new Figure();
        data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = 2;
        layout.setConstraint((IFigure)blankFigure, (Object)data);
        parent.add((IFigure)blankFigure);
        this.commentText = new Label();
        this.commentText.setIconAlignment(8);
        this.commentText.setIcon(COMMENT_IMAGE);
        parent.add((IFigure)this.commentText);
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        layout.setConstraint((IFigure)this.commentText, (Object)data);
    }

    protected void initControls() {
        String comment;
        String outgoingMerges;
        String incomingMerges;
        this.pathText.setIcon(RevisionFigure.getRevisionNodeIcon(this.revisionNode));
        this.pathText.setText(String.valueOf(this.revisionNode.getPath()) + "@" + this.revisionNode.getRevision());
        String author = this.revisionNode.getAuthor();
        this.authorText.setText(author == null || author.length() == 0 ? SVNMessages.SVNInfo_NoAuthor : author);
        long date = this.revisionNode.getDate();
        this.dateText.setText(date == 0L ? SVNMessages.SVNInfo_NoDate : DateFormatter.formatDate((long)date));
        if (this.revisionNode.getCopiedFrom() != null) {
            RevisionNode copiedFrom = this.revisionNode.getCopiedFrom();
            this.copyText.setText(String.valueOf(copiedFrom.getPath()) + "@" + copiedFrom.getRevision());
        }
        if ((incomingMerges = RevisionFigure.getIncomingMergesAsString(this.revisionNode)) != null) {
            this.incomingMergeText.setText(incomingMerges);
        }
        if ((outgoingMerges = RevisionFigure.getOutgoingMergesAsString(this.revisionNode)) != null) {
            this.outgoingMergeText.setText(outgoingMerges);
        }
        this.commentText.setText((comment = this.revisionNode.getMessage()) == null || comment.length() == 0 ? SVNMessages.SVNInfo_NoComment : comment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Range {
        long start;
        long end;

        Range(long start) {
            this.end = this.start = start;
        }

        public String toString() {
            return this.start != this.end ? String.valueOf(this.start) + "-" + this.end : String.valueOf(this.start);
        }

        static List<Range> getRanges(long[] revisions) {
            if (revisions.length == 0) {
                return Collections.emptyList();
            }
            Arrays.sort(revisions);
            ArrayList<Range> ranges = new ArrayList<Range>();
            Range range = new Range(revisions[0]);
            ranges.add(range);
            int i = 1;
            while (i < revisions.length) {
                long rev = revisions[i];
                if (rev - 1L != range.end) {
                    range = new Range(rev);
                    ranges.add(range);
                } else {
                    range.end = rev;
                }
                ++i;
            }
            return ranges;
        }
    }
}

