/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.svn.revision.graph.NodeConnections;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPath;
import org.eclipse.team.svn.revision.graph.graphic.ChangedPath;
import org.eclipse.team.svn.revision.graph.graphic.ChangesNotifier;
import org.eclipse.team.svn.revision.graph.graphic.MergeConnectionNode;
import org.eclipse.team.svn.revision.graph.graphic.NodeMergeData;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNodePropertySource;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionNode
extends NodeConnections<RevisionNode>
implements IAdaptable {
    private final PathRevision pathRevision;
    private final RevisionRootNode rootNode;
    protected final ChangesNotifier changesNotifier;
    protected boolean isFiltered;
    protected boolean isTruncatePath;
    protected boolean isNextCollapsed;
    protected boolean isPreviousCollapsed;
    protected boolean isCopiedFromCollapsed;
    protected boolean isCopiedToCollapsed;
    protected boolean isRenameCollapsed;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected IPropertySource propertySource;
    protected LinkedHashSet<MergeConnectionNode> outgoingMergeConnections = new LinkedHashSet();
    protected LinkedHashSet<MergeConnectionNode> incomingMergeConnections = new LinkedHashSet();
    protected String path;

    public RevisionNode(PathRevision pathRevision, RevisionRootNode rootNode) {
        this.pathRevision = pathRevision;
        this.rootNode = rootNode;
        this.changesNotifier = new ChangesNotifier();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public RevisionNode getNext() {
        if (this.isNextCollapsed) {
            return null;
        }
        RevisionNode node = this;
        while ((node = node.internalGetNext()) != null) {
            if (!node.isFiltered) {
                return node;
            }
            if (!node.isNextCollapsed) continue;
            return null;
        }
        return null;
    }

    public RevisionNode internalGetNext() {
        return (RevisionNode)super.getNext();
    }

    @Override
    public RevisionNode getPrevious() {
        if (this.isPreviousCollapsed) {
            return null;
        }
        RevisionNode node = this;
        while ((node = node.internalGetPrevious()) != null) {
            if (!node.isFiltered) {
                return node;
            }
            if (!node.isPreviousCollapsed) continue;
            return null;
        }
        return null;
    }

    public RevisionNode internalGetPrevious() {
        return (RevisionNode)super.getPrevious();
    }

    public RevisionNode[] getCopiedTo(RevisionNode[] a) {
        return this.getCopiedTo();
    }

    public RevisionNode[] getCopiedTo() {
        return this.getCopiedToAsCollection().toArray(new RevisionNode[0]);
    }

    @Override
    public Collection<RevisionNode> getCopiedToAsCollection() {
        if (this.isCopiedToCollapsed && this.isRenameCollapsed) {
            return Collections.emptyList();
        }
        LinkedList<RevisionNode> result = new LinkedList<RevisionNode>();
        Collection<RevisionNode> copiedTo = this.internalGetCopiedToAsCollection();
        for (RevisionNode node : copiedTo) {
            boolean isRename;
            if (node.isFiltered) continue;
            boolean bl = isRename = node.getAction() == PathRevision.RevisionNodeAction.RENAME;
            if (!isRename && !this.isCopiedToCollapsed) {
                result.add(node);
                continue;
            }
            if (!isRename || this.isRenameCollapsed) continue;
            result.addFirst(node);
        }
        return result;
    }

    public Collection<RevisionNode> internalGetCopiedToAsCollection() {
        return super.getCopiedToAsCollection();
    }

    @Override
    public RevisionNode getCopiedFrom() {
        if (this.isCopiedFromCollapsed) {
            return null;
        }
        RevisionNode copiedFrom = this.internalGetCopiedFrom();
        return copiedFrom != null ? (copiedFrom.isFiltered ? null : copiedFrom) : null;
    }

    public RevisionNode internalGetCopiedFrom() {
        return (RevisionNode)super.getCopiedFrom();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changesNotifier.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changesNotifier.removePropertyChangeListener(listener);
    }

    public void refreshConnections() {
        this.changesNotifier.firePropertyChange("refreshNodeConnections", null, this);
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.rootNode.getRepositoryCache().getPathStorage().getPath(this.pathRevision.getPathIndex());
        }
        return this.path;
    }

    public PathRevision.ReviosionNodeType getType() {
        return this.pathRevision.type;
    }

    public PathRevision.RevisionNodeAction getAction() {
        return this.pathRevision.action;
    }

    public long getRevision() {
        return this.pathRevision.getRevision();
    }

    public String getMessage() {
        int messageIndex = this.pathRevision.getMessageIndex();
        String message = messageIndex != -1 ? this.rootNode.getRepositoryCache().getMessageStorage().getMessage(messageIndex) : null;
        return message;
    }

    public String getAuthor() {
        int authorIndex = this.pathRevision.getAuthorIndex();
        String author = authorIndex != -1 ? (String)this.rootNode.getRepositoryCache().getAuthorStorage().getValue(authorIndex) : null;
        return author;
    }

    public long getDate() {
        return this.pathRevision.getDate();
    }

    public ChangedPath[] getChangedPaths() {
        CacheChangedPath[] rawPaths = this.pathRevision.getChangedPaths();
        ChangedPath[] result = new ChangedPath[rawPaths.length];
        int i = 0;
        while (i < rawPaths.length) {
            CacheChangedPath rawPath = rawPaths[i];
            String path = this.rootNode.getRepositoryCache().getPathStorage().getPath(rawPath.getPathIndex());
            String copiedFromPath = this.rootNode.getRepositoryCache().getPathStorage().getPath(rawPath.getCopiedFromPathIndex());
            result[i] = new ChangedPath(path, rawPath.getAction(), copiedFromPath, rawPath.getCopiedFromRevision());
            ++i;
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new RevisionNodePropertySource(this);
            }
            return this.propertySource;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean hasOutgoingMerges() {
        return this.pathRevision.hasOutgoingMerges();
    }

    public NodeMergeData[] getOutgoingMerges() {
        PathRevision.MergeData[] rawData = this.pathRevision.getOutgoingMerges();
        NodeMergeData[] data = new NodeMergeData[rawData.length];
        int i = 0;
        while (i < rawData.length) {
            String path = this.rootNode.getRepositoryCache().getPathStorage().getPath(rawData[i].path);
            data[i] = new NodeMergeData(path, rawData[i].getRevisions());
            ++i;
        }
        return data;
    }

    public boolean hasIncomingMerges() {
        return this.pathRevision.hasIncomingMerges();
    }

    public NodeMergeData[] getIncomingMerges() {
        PathRevision.MergeData[] rawData = this.pathRevision.getIncomingMerges();
        NodeMergeData[] data = new NodeMergeData[rawData.length];
        int i = 0;
        while (i < rawData.length) {
            String path = this.rootNode.getRepositoryCache().getPathStorage().getPath(rawData[i].path);
            data[i] = new NodeMergeData(path, rawData[i].getRevisions());
            ++i;
        }
        return data;
    }

    public void setTruncatePath(boolean isTruncatePath) {
        this.isTruncatePath = isTruncatePath;
        this.changesNotifier.firePropertyChange("truncateNodePath", null, null);
    }

    public boolean isTruncatePath() {
        return this.isTruncatePath;
    }

    public void setFiltered(boolean isFiltered) {
        this.isFiltered = isFiltered;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public boolean isNextCollapsed() {
        return this.isNextCollapsed;
    }

    public void setNextCollapsed(boolean isNextCollapsed) {
        if (isNextCollapsed) {
            this.rootNode.collapseNext(this);
        } else {
            this.rootNode.expandNext(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetNextCollapsed(boolean isNextCollapsed) {
        this.isNextCollapsed = isNextCollapsed;
    }

    public boolean isPreviousCollapsed() {
        return this.isPreviousCollapsed;
    }

    public void setPreviousCollapsed(boolean isPreviousCollapsed) {
        if (isPreviousCollapsed) {
            this.rootNode.collapsePrevious(this);
        } else {
            this.rootNode.expandPrevious(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetPreviousCollapsed(boolean isPreviousCollapsed) {
        this.isPreviousCollapsed = isPreviousCollapsed;
    }

    public boolean isCopiedToCollapsed() {
        return this.isCopiedToCollapsed;
    }

    public void setCopiedToCollapsed(boolean isCopiedToCollapsed) {
        if (isCopiedToCollapsed) {
            this.rootNode.collapseCopiedTo(this);
        } else {
            this.rootNode.expandCopiedTo(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetCopiedToCollapsed(boolean isCopiedToCollapsed) {
        this.isCopiedToCollapsed = isCopiedToCollapsed;
    }

    public boolean isRenameCollapsed() {
        return this.isRenameCollapsed;
    }

    public void setRenameCollapsed(boolean isRenameCollapsed) {
        if (isRenameCollapsed) {
            this.rootNode.collapseRename(this);
        } else {
            this.rootNode.expandRename(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetRenameCollapsed(boolean isRenameCollapsed) {
        this.isRenameCollapsed = isRenameCollapsed;
    }

    public boolean isCopiedFromCollapsed() {
        return this.isCopiedFromCollapsed;
    }

    public void setCopiedFromCollapsed(boolean isCopiedFromCollapsed) {
        if (isCopiedFromCollapsed) {
            this.rootNode.collapseCopiedFrom(this);
        } else {
            this.rootNode.expandCopiedFrom(this);
        }
        this.changesNotifier.firePropertyChange("expandCollapseOnNode", null, null);
    }

    public void internalSetCopiedFromCollapsed(boolean isCopiedFromCollapsed) {
        this.isCopiedFromCollapsed = isCopiedFromCollapsed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RevisionNode) {
            RevisionNode rNode = (RevisionNode)obj;
            return this.pathRevision.equals(rNode.pathRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.pathRevision.hashCode();
    }

    public String toString() {
        return String.valueOf(this.pathRevision.toString()) + ", location: " + this.x + ", " + this.y + ", size: " + this.width + ", " + this.height;
    }

    public boolean hasIncomingMergeConnections() {
        return !this.incomingMergeConnections.isEmpty();
    }

    public boolean hasOutgoingMergeConnections() {
        return !this.outgoingMergeConnections.isEmpty();
    }

    public List<MergeConnectionNode> getOutgoingMergeConnections() {
        return !this.outgoingMergeConnections.isEmpty() ? new ArrayList<MergeConnectionNode>(this.outgoingMergeConnections) : Collections.emptyList();
    }

    public List<MergeConnectionNode> getIncomingMergeConnections() {
        return !this.incomingMergeConnections.isEmpty() ? new ArrayList<MergeConnectionNode>(this.incomingMergeConnections) : Collections.emptyList();
    }

    public void addAllOutgoingMergeConnections() {
        NodeMergeData[] outgoingMergeDatas;
        if (!this.hasOutgoingMerges()) {
            return;
        }
        boolean isChanged = false;
        NodeMergeData[] nodeMergeDataArray = outgoingMergeDatas = this.getOutgoingMerges();
        int n = outgoingMergeDatas.length;
        int n2 = 0;
        while (n2 < n) {
            NodeMergeData outgoingMergeData = nodeMergeDataArray[n2];
            long[] lArray = outgoingMergeData.revisions;
            int n3 = outgoingMergeData.revisions.length;
            int n4 = 0;
            while (n4 < n3) {
                long revision = lArray[n4];
                List<RevisionNode> endNodes = this.findRevisionNodeForMerge(outgoingMergeData.path, revision);
                for (RevisionNode endNode : endNodes) {
                    MergeConnectionNode mergeConNode = new MergeConnectionNode(this, endNode);
                    if (!this.outgoingMergeConnections.add(mergeConNode)) continue;
                    isChanged = true;
                    endNode.addIncomingMergeConnection(mergeConNode);
                }
                ++n4;
            }
            ++n2;
        }
        if (isChanged) {
            this.changesNotifier.firePropertyChange("refreshMergeSourceConnections", null, this);
        }
    }

    public void addAllIncomingMergeConnections() {
        NodeMergeData[] incomingMergeDatas;
        if (!this.hasIncomingMerges()) {
            return;
        }
        boolean isChanged = false;
        NodeMergeData[] nodeMergeDataArray = incomingMergeDatas = this.getIncomingMerges();
        int n = incomingMergeDatas.length;
        int n2 = 0;
        while (n2 < n) {
            NodeMergeData incomingMergeData = nodeMergeDataArray[n2];
            long[] lArray = incomingMergeData.revisions;
            int n3 = incomingMergeData.revisions.length;
            int n4 = 0;
            while (n4 < n3) {
                long revision = lArray[n4];
                List<RevisionNode> startNodes = this.findRevisionNodeForMerge(incomingMergeData.path, revision);
                for (RevisionNode startNode : startNodes) {
                    MergeConnectionNode mergeConNode = new MergeConnectionNode(startNode, this);
                    if (!this.incomingMergeConnections.add(mergeConNode)) continue;
                    isChanged = true;
                    startNode.addOutgoingMergeConnection(mergeConNode);
                }
                ++n4;
            }
            ++n2;
        }
        if (isChanged) {
            this.changesNotifier.firePropertyChange("refreshMergeTargetConnections", null, this);
        }
    }

    public void removeAllOutgoingMergeConnections() {
        if (this.outgoingMergeConnections.isEmpty()) {
            return;
        }
        boolean isChanged = false;
        Iterator iter = this.outgoingMergeConnections.iterator();
        while (iter.hasNext()) {
            MergeConnectionNode con = (MergeConnectionNode)iter.next();
            con.getTarget().removeIncomingMergeConnection(con);
            iter.remove();
            isChanged = true;
        }
        if (isChanged) {
            this.changesNotifier.firePropertyChange("refreshMergeSourceConnections", null, this);
        }
    }

    public void removeAllIncomingMergeConnections() {
        if (this.incomingMergeConnections.isEmpty()) {
            return;
        }
        boolean isChanged = false;
        Iterator iter = this.incomingMergeConnections.iterator();
        while (iter.hasNext()) {
            MergeConnectionNode con = (MergeConnectionNode)iter.next();
            con.getSource().removeOutgoingMergeConnection(con);
            iter.remove();
            isChanged = true;
        }
        if (isChanged) {
            this.changesNotifier.firePropertyChange("refreshMergeTargetConnections", null, this);
        }
    }

    protected void addIncomingMergeConnection(MergeConnectionNode conn) {
        if (conn.target == this && this.incomingMergeConnections.add(conn)) {
            this.changesNotifier.firePropertyChange("refreshMergeTargetConnections", null, this);
        }
    }

    protected void addOutgoingMergeConnection(MergeConnectionNode conn) {
        if (conn.source == this && this.outgoingMergeConnections.add(conn)) {
            this.changesNotifier.firePropertyChange("refreshMergeSourceConnections", null, this);
        }
    }

    protected void removeIncomingMergeConnection(MergeConnectionNode conn) {
        if (conn.target == this && this.incomingMergeConnections.remove(conn)) {
            this.changesNotifier.firePropertyChange("refreshMergeTargetConnections", null, this);
        }
    }

    protected void removeOutgoingMergeConnection(MergeConnectionNode conn) {
        if (conn.source == this && this.outgoingMergeConnections.remove(conn)) {
            this.changesNotifier.firePropertyChange("refreshMergeSourceConnections", null, this);
        }
    }

    protected List<RevisionNode> findRevisionNodeForMerge(String path, long revision) {
        List<RevisionNode> result = Collections.emptyList();
        List<RevisionNode> children = this.rootNode.getChildren();
        for (RevisionNode node : children) {
            if (revision != node.getRevision() || !path.equals(node.getPath()) || node.getAction() == PathRevision.RevisionNodeAction.NONE) continue;
            if (result.isEmpty()) {
                result = new ArrayList<RevisionNode>();
            }
            result.add(node);
        }
        return result;
    }
}

