/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.va;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.processes.ProcessLauncher;
import org.eclipse.tcf.te.runtime.processes.ProcessOutputReaderThread;
import org.eclipse.tcf.te.runtime.utils.Env;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.nls.Messages;
import org.eclipse.tcf.te.tcf.core.va.ValueAddException;
import org.osgi.framework.Bundle;

public class ValueAddLauncher
extends ProcessLauncher {
    private final String id;
    private final IPath path;
    private final String valueAddId;
    private Process process;
    private ProcessOutputReaderThread outputReader;
    private ProcessOutputReaderThread errorReader;

    public ValueAddLauncher(String id, IPath path, String valueAddId) {
        super(null, null, 0);
        Assert.isNotNull((Object)id);
        this.id = id;
        Assert.isNotNull((Object)path);
        this.path = path;
        Assert.isNotNull((Object)valueAddId);
        this.valueAddId = valueAddId;
    }

    protected final String getPeerId() {
        return this.id;
    }

    public final Process getProcess() {
        return this.process;
    }

    public final ProcessOutputReaderThread getOutputReader() {
        return this.outputReader;
    }

    public final ProcessOutputReaderThread getErrorReader() {
        return this.errorReader;
    }

    public void launch() throws ValueAddException {
        IPath dir = this.path.removeLastSegments(1);
        String cmd = Host.isWindowsHost() ? this.path.toOSString() : "./" + this.path.lastSegment();
        ArrayList<String> command = new ArrayList<String>();
        command.add(cmd);
        this.addCommandLineParameters(command);
        this.addLoggingCommandLineParameters(command);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ValueAddLauncher_launch_command, (Object[])new Object[]{command, this.id, this.valueAddId}), 0, "trace/channelManager", 1, (Object)this);
        }
        String[] envp = null;
        String[] additional = this.getEnvironmentVariables();
        if (additional != null && additional.length > 0) {
            envp = Env.getEnvironment((String[])additional, (boolean)false);
        }
        this.process = this.exec(command.toArray(new String[command.size()]), envp, dir.toFile());
        this.outputReader = this.createProcessOutputReaderThread(this.path, this.process.getInputStream());
        this.outputReader.start();
        this.errorReader = this.createProcessOutputReaderThread(this.path, this.process.getErrorStream());
        this.errorReader.start();
    }

    protected void addToCommand(List<String> command, String arg) {
        Assert.isNotNull(command);
        Assert.isNotNull((Object)arg);
        command.add(arg);
    }

    protected void addCommandLineParameters(List<String> command) throws ValueAddException {
        Assert.isNotNull(command);
        int port = this.getFreePort();
        this.addToCommand(command, "-I180");
        this.addToCommand(command, "-S");
        this.addToCommand(command, "-sTCP::" + (port != -1 ? Integer.valueOf(port) : "") + ";ValueAdd=1");
    }

    protected void addLoggingCommandLineParameters(List<String> command) throws ValueAddException {
        Assert.isNotNull(command);
        if (Boolean.getBoolean("va.logging.enable")) {
            IPath location;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.tcf.te.tcf.log.core");
            IPath iPath = location = bundle != null ? Platform.getStateLocation((Bundle)bundle) : null;
            if (location != null) {
                location = location.append(".logs");
                String name = "Output_" + this.valueAddId + "_" + this.id + ".log";
                name = name.replaceAll("\\s", "_");
                name = name.replaceAll("[:/\\;,]", "_");
                location = location.append(name);
                this.addToCommand(command, "-L" + location.toString());
                String level = System.getProperty("va.logging.level");
                if (level != null && !"".equals(level.trim())) {
                    this.addToCommand(command, "-l" + level.trim());
                }
            }
        }
    }

    protected Process exec(String[] cmdarray, String[] envp, File dir) throws ValueAddException {
        Assert.isNotNull((Object)cmdarray);
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmdarray, envp, dir);
        }
        catch (IOException e) {
            throw new ValueAddException(e);
        }
        return process;
    }

    protected ProcessOutputReaderThread createProcessOutputReaderThread(IPath path, InputStream stream) {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)stream);
        return new ProcessOutputReaderThread(path.lastSegment(), new InputStream[]{stream});
    }

    protected int getFreePort() {
        int port = -1;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException iOException) {}
        return port;
    }

    protected String[] getEnvironmentVariables() {
        return null;
    }
}

