/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.servicesubsystem;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.SystemRemoteChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.internal.subsystems.files.core.Activator;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.AbstractRemoteFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileSubSystemInputStream;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileSubSystemOutputStream;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.SearchJob;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEncodingManager;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;

public class FileServiceSubSystem
extends RemoteFileSubSystem
implements IFileServiceSubSystem {
    protected ILanguageUtilityFactory _languageUtilityFactory;
    protected IFileService _hostFileService;
    protected ISearchService _hostSearchService;
    protected IHostFileToRemoteFileAdapter _hostFileToRemoteFileAdapter;
    protected IRemoteFile _userHome;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public FileServiceSubSystem(IHost host, IConnectorService connectorService, IFileService hostFileService, IHostFileToRemoteFileAdapter fileAdapter, ISearchService searchService) {
        super(host, connectorService);
        this._hostFileService = hostFileService;
        this._hostFileToRemoteFileAdapter = fileAdapter;
        this._hostSearchService = searchService;
    }

    public boolean isCaseSensitive() {
        return this.getFileService().isCaseSensitive();
    }

    public IRemoteFileContext getContextFor(IRemoteFile file) {
        return this.getContext(file);
    }

    public IRemoteFileContext getTheDefaultContext() {
        return this.getDefaultContextNoFilterString();
    }

    public IFileService getFileService() {
        return this._hostFileService;
    }

    public void setFileService(IFileService service) {
        this._hostFileService = service;
    }

    public ISearchService getSearchService() {
        return this._hostSearchService;
    }

    public void setSearchService(ISearchService service) {
        this._hostSearchService = service;
    }

    public IHostFileToRemoteFileAdapter getHostFileToRemoteFileAdapter() {
        return this._hostFileToRemoteFileAdapter;
    }

    public void setHostFileToRemoteFileAdapter(IHostFileToRemoteFileAdapter hostFileAdapter) {
        this._hostFileToRemoteFileAdapter = hostFileAdapter;
    }

    public IRemoteFile getRemoteFileObject(IRemoteFile parent, String folderOrFileName, IProgressMonitor monitor) throws SystemMessageException {
        if (!$assertionsDisabled && folderOrFileName.indexOf(this.getSeparator()) >= 0) {
            throw new AssertionError();
        }
        this.checkIsConnected(monitor);
        String fullPath = String.valueOf(parent.getAbsolutePath()) + this.getSeparator() + folderOrFileName;
        IRemoteFile file = this.getCachedRemoteFile(fullPath);
        if (file != null && !file.isStale()) {
            return file;
        }
        if (folderOrFileName.indexOf(this.getSeparator()) >= 0) {
            try {
                throw new IllegalArgumentException("getRemoteFileObject: folderOrFileName must not be a relative path");
            }
            catch (IllegalArgumentException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.rse.subsystems.files.core", "Illegal API use: " + e.getLocalizedMessage(), (Throwable)e));
                return this.getRemoteFileObject(fullPath, monitor);
            }
        }
        IHostFile node = this.getFile(parent.getAbsolutePath(), folderOrFileName, monitor);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, node);
    }

    public IRemoteFile getRemoteFileObject(String folderOrFileName, IProgressMonitor monitor) throws SystemMessageException {
        int j;
        IRemoteFile file;
        String fofName = folderOrFileName;
        if (folderOrFileName.length() > 1) {
            fofName = ArchiveHandlerManager.cleanUpVirtualPath((String)folderOrFileName);
        }
        if ((file = this.getCachedRemoteFile(fofName)) != null && !file.isStale()) {
            return file;
        }
        this.checkIsConnected(monitor);
        if (fofName.endsWith("#virtual#/")) {
            fofName = fofName.substring(0, fofName.length() - "#virtual#/".length());
        }
        if ((j = fofName.indexOf("#virtual#/")) == -1) {
            if (fofName.equals("/")) {
                try {
                    return this.listRoots(null)[0];
                }
                catch (Exception exception) {}
            }
            if (fofName.equals(".")) {
                IRemoteFile userHome = this.getUserHome();
                if (userHome == null) {
                    SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.subsystems.files.core", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED);
                    throw new SystemMessageException((SystemMessage)msg);
                }
                return userHome;
            }
            String sep = PathUtility.getSeparator((String)folderOrFileName);
            if (fofName.endsWith(sep)) {
                fofName = fofName.substring(0, fofName.length() - sep.length());
            }
            if (fofName.endsWith(":")) {
                try {
                    IHostFile[] roots = this.getRoots(null);
                    int i = 0;
                    while (i < roots.length) {
                        if (roots[i].getAbsolutePath().toLowerCase().startsWith(fofName.toLowerCase())) {
                            return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), null, roots[i]);
                        }
                        ++i;
                    }
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
            int lastSep = fofName.lastIndexOf(sep);
            if (lastSep > -1) {
                String name;
                IHostFile node;
                String parentPath = fofName.substring(0, lastSep);
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                if ((node = this.getFile(parentPath, name = fofName.substring(lastSep + 1, fofName.length()), monitor)) != null) {
                    IRemoteFile parent = null;
                    node.isRoot();
                    return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, node);
                }
            }
            return null;
        }
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(fofName);
        IHostFile node = this.getFile(avp.getPath(), avp.getName(), null);
        if (node != null) {
            return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), null, node);
        }
        return null;
    }

    protected IRemoteFile getUserHome() {
        if (this._userHome != null) {
            return this._userHome;
        }
        IRemoteFile root = this.getCachedRemoteFile(".");
        if (root != null && !root.isStale()) {
            return root;
        }
        IHostFile userHome = this.getFileService().getUserHome();
        if (userHome == null) {
            return null;
        }
        IRemoteFile parent = null;
        if (!".".equals(userHome.getParentPath())) {
            // empty if block
        }
        root = this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, userHome);
        this.cacheRemoteFile(root, ".");
        this._userHome = root;
        return root;
    }

    protected IHostFile[] internalList(String parentPath, String fileNameFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().list(parentPath, fileNameFilter, fileType, monitor);
    }

    protected IHostFile getFile(String parentPath, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().getFile(parentPath, fileName, monitor);
    }

    protected IHostFile[] getRoots(IProgressMonitor monitor) throws InterruptedException, SystemMessageException {
        return this.getFileService().getRoots(monitor);
    }

    public IRemoteFile[] getRemoteFileObjects(String[] folderOrFileNames, IProgressMonitor monitor) throws SystemMessageException {
        this.checkIsConnected(monitor);
        String[] parentPaths = new String[folderOrFileNames.length];
        String[] names = new String[folderOrFileNames.length];
        String sep = null;
        int i = 0;
        while (i < folderOrFileNames.length) {
            String fofName = folderOrFileNames[i];
            if (sep == null) {
                sep = PathUtility.getSeparator((String)fofName);
            }
            String parentPath = null;
            String name = null;
            int lastSep = fofName.lastIndexOf(sep);
            if (lastSep > -1) {
                parentPath = fofName.substring(0, lastSep);
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                name = fofName.substring(lastSep + 1, fofName.length());
            }
            parentPaths[i] = parentPath;
            names[i] = name;
            ++i;
        }
        RemoteFileContext context = this.getDefaultContext();
        ArrayList hostFiles = new ArrayList(10);
        this.getFileService().getFileMultiple(parentPaths, names, hostFiles, monitor);
        IHostFile[] nodes = new IHostFile[hostFiles.size()];
        hostFiles.toArray(nodes);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, null, nodes);
    }

    public IRemoteFile[] listMultiple(IRemoteFile[] parents, String[] fileNameFilters, int[] fileTypes, IProgressMonitor monitor) throws SystemMessageException {
        String[] parentPaths = new String[parents.length];
        int i = 0;
        while (i < parents.length) {
            parentPaths[i] = parents[i].getAbsolutePath();
            ++i;
        }
        ArrayList hostFiles = new ArrayList(10);
        this.getFileService().listMultiple(parentPaths, fileNameFilters, fileTypes, hostFiles, monitor);
        RemoteFileContext context = this.getDefaultContext();
        IHostFile[] results = hostFiles.toArray(new IHostFile[hostFiles.size()]);
        IRemoteFile[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, null, results);
        int i2 = 0;
        while (i2 < parents.length) {
            IRemoteFile parent = parents[i2];
            String parentPath = parentPaths[i2];
            String filter = fileNameFilters[i2];
            ArrayList<IRemoteFile> underParent = new ArrayList<IRemoteFile>();
            int j = 0;
            while (j < farr.length) {
                IRemoteFile child = farr[j];
                String childParentPath = child.getParentPath();
                if (parentPath.equals(childParentPath)) {
                    underParent.add(child);
                }
                ++j;
            }
            this.updateRemoteFile(parent, null, monitor);
            if (underParent.size() > 0) {
                Object[] qresults = underParent.toArray();
                parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter, qresults);
            }
            ++i2;
        }
        return farr;
    }

    public IRemoteFile[] listMultiple(IRemoteFile[] parents, String[] fileNameFilters, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        String[] parentPaths = new String[parents.length];
        int i = 0;
        while (i < parents.length) {
            parentPaths[i] = parents[i].getAbsolutePath();
            ++i;
        }
        ArrayList hostFiles = new ArrayList(10);
        this.getFileService().listMultiple(parentPaths, fileNameFilters, fileType, hostFiles, monitor);
        RemoteFileContext context = this.getDefaultContext();
        IHostFile[] results = hostFiles.toArray(new IHostFile[hostFiles.size()]);
        IRemoteFile[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, null, results);
        int i2 = 0;
        while (i2 < parents.length) {
            IRemoteFile parent = parents[i2];
            String parentPath = parentPaths[i2];
            String filter = fileNameFilters[i2];
            ArrayList<IRemoteFile> underParent = new ArrayList<IRemoteFile>();
            int j = 0;
            while (j < farr.length) {
                IRemoteFile child = farr[j];
                String childParentPath = ((AbstractRemoteFile)child).getParentPath();
                if (parentPath.equals(childParentPath)) {
                    underParent.add(child);
                }
                ++j;
            }
            this.updateRemoteFile(parent, null, monitor);
            if (underParent.size() > 0) {
                Object[] qresults = underParent.toArray();
                parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter, qresults);
            }
            ++i2;
        }
        return farr;
    }

    public IRemoteFile[] list(IRemoteFile parent, String fileNameFilter, IRemoteFileContext context, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        String parentPath = null;
        parentPath = parent != null ? parent.getAbsolutePath() : "/";
        if (parent != null && !parent.canRead()) {
            String msgTxt = NLS.bind((String)SystemFileResources.MSG_FOLDER_UNREADABLE, (Object)parentPath);
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.subsystems.files.core", "RSEF5020", 1, msgTxt);
            throw new SystemMessageException((SystemMessage)msg);
        }
        IHostFile[] results = this.internalList(parentPath, fileNameFilter, fileType, monitor);
        this.updateRemoteFile(parent, null, monitor);
        Object[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, parent, results);
        if (parent != null) {
            parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), fileNameFilter, farr);
        }
        return farr;
    }

    private void updateRemoteFile(IRemoteFile parent, IHostFile newHostParent, IProgressMonitor monitor) throws SystemMessageException {
        IHostFile oldHostParent;
        if (newHostParent == null) {
            String parentParentPath = parent.getParentPath();
            if (parentParentPath == null) {
                parentParentPath = "";
            }
            newHostParent = this.getFileService().getFile(parentParentPath, parent.getName(), monitor);
        }
        if (newHostParent != null && !newHostParent.equals(oldHostParent = parent.getHostFile())) {
            ((AbstractRemoteFile)parent).setHostFile(newHostParent);
            parent.markStale(false);
        }
    }

    public IRemoteFile[] listRoots(IRemoteFileContext context, IProgressMonitor monitor) throws InterruptedException {
        IHostFile[] roots = null;
        try {
            roots = this.getRoots(monitor);
        }
        catch (SystemMessageException systemMessageException) {}
        IRemoteFile[] results = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, null, roots);
        return results;
    }

    protected boolean isBinary(String localEncoding, String hostEncoding, String remotePath) {
        ISystemFileTransferModeRegistry reg = RemoteFileUtility.getSystemFileTransferModeRegistry();
        return reg.isBinary(remotePath) || reg.isXML(remotePath);
    }

    protected boolean isBinary(IRemoteFile source) {
        return source.isBinary();
    }

    public void upload(String source, String srcEncoding, String remotePath, String rmtEncoding, IProgressMonitor monitor) throws SystemMessageException {
        int slashIndex = remotePath.lastIndexOf(this.getSeparator());
        if (slashIndex > -1) {
            String remoteParentPath = remotePath.substring(0, slashIndex);
            String remoteFileName = remotePath.substring(slashIndex + 1, remotePath.length());
            boolean isBinary = this.isBinary(srcEncoding, rmtEncoding, remotePath);
            if (ArchiveHandlerManager.isVirtual((String)remotePath)) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(remotePath);
                remoteParentPath = avp.getPath();
                remoteFileName = avp.getName();
            }
            this.getFileService().upload(new File(source), remoteParentPath, remoteFileName, isBinary, srcEncoding, rmtEncoding, monitor);
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            sr.fireEvent((ISystemRemoteChangeEvent)new SystemRemoteChangeEvent(20, (Object)remotePath, (Object)remoteParentPath, (ISubSystem)this));
        }
    }

    public void upload(String source, IRemoteFile destination, String encoding, IProgressMonitor monitor) throws SystemMessageException {
        String remoteParentPath = destination.getParentPath();
        String remoteFileName = destination.getName();
        String hostEncoding = destination.getEncoding();
        boolean isBinary = this.isBinary(encoding, hostEncoding, destination.getAbsolutePath());
        if (destination.exists() && !destination.canWrite() || !destination.exists() && !destination.getParentRemoteFile().canWrite()) {
            String msgTxt = NLS.bind((String)SystemFileResources.MSG_FILE_CANNOT_BE_SAVED, (Object)remoteFileName, (Object)this.getHostName());
            String msgDetails = SystemFileResources.MSG_FILE_CANNOT_BE_SAVED_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.subsystems.files.core", "RSEF5003", 4, msgTxt, msgDetails);
            throw new SystemMessageException((SystemMessage)msg);
        }
        this.getFileService().upload(new File(source), remoteParentPath, remoteFileName, isBinary, encoding, hostEncoding, monitor);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.fireEvent((ISystemRemoteChangeEvent)new SystemRemoteChangeEvent(20, (Object)destination, (Object)destination.getParentRemoteFile(), (ISubSystem)this));
    }

    public void uploadMultiple(String[] sources, String[] srcEncodings, String[] remotePaths, String[] rmtEncodings, IProgressMonitor monitor) throws SystemMessageException {
        File[] sourceFiles = new File[sources.length];
        boolean[] isBinaries = new boolean[sources.length];
        String[] remoteParentPaths = new String[sources.length];
        String[] remoteFileNames = new String[sources.length];
        int i = 0;
        while (i < sources.length) {
            sourceFiles[i] = new File(sources[i]);
            String remotePath = remotePaths[i];
            int slashIndex = remotePath.lastIndexOf(this.getSeparator());
            if (slashIndex > -1) {
                remoteParentPaths[i] = remotePath.substring(0, slashIndex);
                remoteFileNames[i] = remotePath.substring(slashIndex + 1, remotePath.length());
                isBinaries[i] = this.isBinary(srcEncodings[i], rmtEncodings[i], remotePath);
                if (ArchiveHandlerManager.isVirtual((String)remotePath)) {
                    AbsoluteVirtualPath avp = new AbsoluteVirtualPath(remotePath);
                    remoteParentPaths[i] = avp.getPath();
                    remoteFileNames[i] = avp.getName();
                }
            }
            ++i;
        }
        this.getFileService().uploadMultiple(sourceFiles, remoteParentPaths, remoteFileNames, isBinaries, srcEncodings, rmtEncodings, monitor);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        int j = 0;
        while (j < remotePaths.length) {
            String remotePath = remotePaths[j];
            String remoteParentPath = remoteParentPaths[j];
            sr.fireEvent((ISystemRemoteChangeEvent)new SystemRemoteChangeEvent(20, (Object)remotePath, (Object)remoteParentPath, (ISubSystem)this));
            ++j;
        }
    }

    public void uploadMultiple(String[] sources, IRemoteFile[] destinations, String[] encodings, IProgressMonitor monitor) throws SystemMessageException {
        File[] sourceFiles = new File[sources.length];
        boolean[] isBinaries = new boolean[sources.length];
        String[] remoteParentPaths = new String[sources.length];
        String[] remoteFileNames = new String[sources.length];
        String[] hostEncodings = new String[sources.length];
        int i = 0;
        while (i < sources.length) {
            sourceFiles[i] = new File(sources[i]);
            IRemoteFile destination = destinations[i];
            remoteParentPaths[i] = destination.getAbsolutePath();
            remoteFileNames[i] = destination.getName();
            if (!destination.canWrite()) {
                String msgTxt = NLS.bind((String)SystemFileResources.MSG_FILE_CANNOT_BE_SAVED, (Object)remoteFileNames[i], (Object)this.getHostName());
                String msgDetails = SystemFileResources.MSG_FILE_CANNOT_BE_SAVED_DETAILS;
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.subsystems.files.core", "RSEF5003", 4, msgTxt, msgDetails);
                throw new SystemMessageException((SystemMessage)msg);
            }
            hostEncodings[i] = destination.getEncoding();
            isBinaries[i] = this.isBinary(encodings[i], hostEncodings[i], destination.getAbsolutePath());
            ++i;
        }
        this.getFileService().uploadMultiple(sourceFiles, remoteParentPaths, remoteFileNames, isBinaries, encodings, hostEncodings, monitor);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        int j = 0;
        while (j < destinations.length) {
            IRemoteFile destination = destinations[j];
            sr.fireEvent((ISystemRemoteChangeEvent)new SystemRemoteChangeEvent(20, (Object)destination, (Object)destination.getParentRemoteFile(), (ISubSystem)this));
            ++j;
        }
    }

    public void download(IRemoteFile file, String localpath, String encoding, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String parentPath = file.getParentPath();
        File localFile = new File(localpath);
        this.getFileService().download(parentPath, file.getName(), localFile, this.isBinary(file), file.getEncoding(), monitor);
        if (monitor.isCanceled()) {
            localFile.delete();
        } else {
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            sr.fireEvent((ISystemRemoteChangeEvent)new SystemRemoteChangeEvent(24, (Object)file, (Object)file.getParentRemoteFile(), (ISubSystem)this));
        }
    }

    public void downloadMultiple(IRemoteFile[] sources, String[] destinations, String[] encodings, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] parentPaths = new String[sources.length];
        String[] names = new String[sources.length];
        boolean[] isBinaries = new boolean[sources.length];
        File[] localFiles = new File[sources.length];
        int i = 0;
        while (i < sources.length) {
            IRemoteFile file = sources[i];
            parentPaths[i] = file.getParentPath();
            names[i] = file.getName();
            isBinaries[i] = this.isBinary(file);
            localFiles[i] = new File(destinations[i]);
            ++i;
        }
        this.getFileService().downloadMultiple(parentPaths, names, localFiles, isBinaries, encodings, monitor);
        if (monitor.isCanceled()) {
            int d = 0;
            while (d < localFiles.length) {
                File f = localFiles[d];
                f.delete();
                ++d;
            }
        } else {
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            int r = 0;
            while (r < sources.length) {
                IRemoteFile file = sources[r];
                sr.fireEvent((ISystemRemoteChangeEvent)new SystemRemoteChangeEvent(24, (Object)file, (Object)file.getParentRemoteFile(), (ISubSystem)this));
                ++r;
            }
        }
    }

    public void copy(IRemoteFile sourceFolderOrFile, IRemoteFile targetFolder, String newName, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        service.copy(sourceFolderOrFile.getParentPath(), sourceFolderOrFile.getName(), targetFolder.getAbsolutePath(), newName, monitor);
    }

    public void copyBatch(IRemoteFile[] sourceFolderOrFiles, IRemoteFile targetFolder, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String[] sourceParents = new String[sourceFolderOrFiles.length];
        String[] sourceNames = new String[sourceFolderOrFiles.length];
        int i = 0;
        while (i < sourceFolderOrFiles.length) {
            sourceParents[i] = sourceFolderOrFiles[i].getParentPath();
            sourceNames[i] = sourceFolderOrFiles[i].getName();
            ++i;
        }
        service.copyBatch(sourceParents, sourceNames, targetFolder.getAbsolutePath(), monitor);
    }

    public IRemoteFile getParentFolder(IRemoteFile folderOrFile, IProgressMonitor monitor) {
        try {
            return this.getRemoteFileObject(folderOrFile.getParentPath(), monitor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IRemoteFile createFile(IRemoteFile fileToCreate, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String parent = fileToCreate.getParentPath();
        String name = fileToCreate.getName();
        IHostFile newFile = service.createFile(parent, name, monitor);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), fileToCreate.getParentRemoteFile(), newFile);
    }

    public IRemoteFile createFolder(IRemoteFile folderToCreate, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String parent = folderToCreate.getParentPath();
        String name = folderToCreate.getName();
        IHostFile newFolder = service.createFolder(parent, name, monitor);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), folderToCreate.getParentRemoteFile(), newFolder);
    }

    /*
     * Unable to fully structure code
     */
    public IRemoteFile createFolders(IRemoteFile folderToCreate, IProgressMonitor monitor) throws SystemMessageException {
        try {
            return this.createFolder(folderToCreate, monitor);
        }
        catch (SystemMessageException e) {
            service = this.getFileService();
            parents = new ArrayList<IRemoteFile>();
            parent = folderToCreate;
            ** while (!parent.isRoot())
        }
lbl-1000:
        // 1 sources

        {
            parentFile = service.getFile((parent = parent.getParentRemoteFile()).getParentPath(), parent.getName(), monitor);
            if (parentFile.exists()) {
                this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent.getParentRemoteFile(), parentFile);
                break;
            }
            parents.add(parent);
            continue;
        }
lbl16:
        // 2 sources

        if (parents.size() == 0) {
            throw e;
        }
        i = parents.size() - 1;
        while (i >= 0) {
            parent = (IRemoteFile)parents.get(i);
            parent.markStale(true, true);
            this.createFolder(parent, monitor);
            --i;
        }
        return this.createFolder(folderToCreate, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(IRemoteFile folderOrFile, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String parent = folderOrFile.getParentPath();
        String name = folderOrFile.getName();
        try {
            service.delete(parent, name, monitor);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            folderOrFile.markStale(true);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        folderOrFile.markStale(true);
    }

    public void deleteBatch(IRemoteFile[] folderOrFiles, IProgressMonitor monitor) throws SystemMessageException {
        String[] parents = new String[folderOrFiles.length];
        String[] names = new String[folderOrFiles.length];
        int i = 0;
        while (i < folderOrFiles.length) {
            parents[i] = folderOrFiles[i].getParentPath();
            names[i] = folderOrFiles[i].getName();
            folderOrFiles[i].markStale(true);
            this.removeCachedRemoteFile(folderOrFiles[i]);
            ++i;
        }
        IFileService service = this.getFileService();
        service.deleteBatch(parents, names, monitor);
    }

    public void rename(IRemoteFile folderOrFile, String newName, IProgressMonitor monitor) throws SystemMessageException {
        this.removeCachedRemoteFile(folderOrFile);
        IFileService service = this.getFileService();
        String srcParent = folderOrFile.getParentPath();
        String oldName = folderOrFile.getName();
        String newPath = String.valueOf(srcParent) + folderOrFile.getSeparator() + newName;
        String originalEncoding = folderOrFile.getEncoding();
        service.rename(srcParent, oldName, newName, monitor);
        folderOrFile.getHostFile().renameTo(newPath);
        RemoteFileEncodingManager mgr = RemoteFileEncodingManager.getInstance();
        String renamedEncoding = folderOrFile.getEncoding();
        if (!renamedEncoding.equals(originalEncoding)) {
            mgr.setEncoding(this.getHostName(), newPath, originalEncoding);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(IRemoteFile sourceFolderOrFile, IRemoteFile targetFolder, String newName, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String srcParent = sourceFolderOrFile.getParentPath();
        String srcName = sourceFolderOrFile.getName();
        String tgtParent = targetFolder.getAbsolutePath();
        this.removeCachedRemoteFile(sourceFolderOrFile);
        String newPath = String.valueOf(tgtParent) + targetFolder.getSeparator() + newName;
        String originalEncoding = sourceFolderOrFile.getEncoding();
        try {
            service.move(srcParent, srcName, tgtParent, newName, monitor);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            sourceFolderOrFile.markStale(true);
            targetFolder.markStale(true);
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        sourceFolderOrFile.markStale(true);
        targetFolder.markStale(true);
        RemoteFileEncodingManager mgr = RemoteFileEncodingManager.getInstance();
        IRemoteFile movedFile = this.getRemoteFileObject(targetFolder, newName, monitor);
        if (movedFile != null && !movedFile.getEncoding().equals(originalEncoding)) {
            mgr.setEncoding(this.getHostName(), newPath, originalEncoding);
        }
    }

    public void setLastModified(IRemoteFile folderOrFile, long newDate, IProgressMonitor monitor) throws SystemMessageException {
        String name = folderOrFile.getName();
        String parent = folderOrFile.getParentPath();
        folderOrFile.markStale(true);
        this._hostFileService.setLastModified(parent, name, newDate, monitor);
    }

    public void setReadOnly(IRemoteFile folderOrFile, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        String name = folderOrFile.getName();
        String parent = folderOrFile.getParentPath();
        folderOrFile.markStale(true);
        this._hostFileService.setReadOnly(parent, name, readOnly, monitor);
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory() {
        if (this._languageUtilityFactory == null) {
            this._languageUtilityFactory = ((IFileServiceSubSystemConfiguration)this.getParentRemoteFileSubSystemConfiguration()).getLanguageUtilityFactory(this);
        }
        return this._languageUtilityFactory;
    }

    public void setLanguageUtilityFactory(ILanguageUtilityFactory factory) {
        this._languageUtilityFactory = factory;
    }

    public void search(IHostSearchResultConfiguration searchConfig) {
        ISearchService searchService = this.getSearchService();
        if (searchService != null) {
            SearchJob job = new SearchJob(searchConfig, searchService, this.getFileService());
            job.schedule();
        }
    }

    public void cancelSearch(IHostSearchResultConfiguration searchConfig) {
        ISearchService searchService = this.getSearchService();
        if (searchService != null) {
            searchService.cancelSearch(searchConfig, null);
        }
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        IFileServiceSubSystemConfiguration factory;
        ISearchService searchService = this.getSearchService();
        if (searchService != null && (factory = (IFileServiceSubSystemConfiguration)this.getParentRemoteFileSubSystemConfiguration()) != null) {
            return factory.createSearchConfiguration(this.getHost(), resultSet, searchTarget, searchString);
        }
        return null;
    }

    public boolean canSwitchTo(ISubSystemConfiguration configuration) {
        return configuration instanceof IFileServiceSubSystemConfiguration;
    }

    protected void internalSwitchSubSystemConfiguration(ISubSystemConfiguration newConfig) {
        if (newConfig instanceof IFileServiceSubSystemConfiguration) {
            IHost host = this.getHost();
            IFileServiceSubSystemConfiguration config = (IFileServiceSubSystemConfiguration)newConfig;
            this.clearRemoteFileCache();
            this._languageUtilityFactory = null;
            this.setFileService(config.getFileService(host));
            this.setHostFileToRemoteFileAdapter(config.getHostFileAdapter());
            this.setSearchService(config.getSearchService(host));
        }
    }

    public Class getServiceType() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        this.getFileService().initService(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        this.getFileService().uninitService(monitor);
        this._userHome = null;
        super.uninitializeSubSystem(monitor);
    }

    public String getRemoteEncoding() {
        try {
            IHost host = this.getHost();
            String encoding = host.getDefaultEncoding(false);
            if (encoding == null && (encoding = this.getFileService().getEncoding(null)) != null) {
                host.setDefaultEncoding(encoding, true);
            }
            if (encoding != null) {
                return encoding;
            }
            return super.getRemoteEncoding();
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
            return super.getRemoteEncoding();
        }
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return new FileSubSystemInputStream(this.getFileService().getInputStream(remoteParent, remoteFile, isBinary, monitor), remoteParent, remoteFile, this);
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return new FileSubSystemOutputStream(this.getFileService().getOutputStream(remoteParent, remoteFile, isBinary, monitor), remoteParent, remoteFile, this);
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, int options, IProgressMonitor monitor) throws SystemMessageException {
        return new FileSubSystemOutputStream(this.getFileService().getOutputStream(remoteParent, remoteFile, options, monitor), remoteParent, remoteFile, this);
    }

    public boolean supportsEncodingConversion() {
        return this.getFileService().supportsEncodingConversion();
    }
}

