/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions.newprojectwizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.php.internal.ui.actions.newprojectwizard.NewWizardSelectionPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizard
extends Wizard {
    private static final String EXAMPLE = "example";
    private static final String ZEND = ".zend.";
    private static final String CATEGORY_SEPARATOR = "/";
    private String categoryId = null;
    private NewWizardSelectionPage mainPage;
    private boolean projectsOnly = false;
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public void addPages() {
        IWizardCategory root = WorkbenchPlugin.getDefault().getNewWizardRegistry().getRootCategory();
        IWizardDescriptor[] primary = new IWizardDescriptor[]{};
        if (this.projectsOnly) {
            ArrayList<IWizardDescriptor> wizards = new ArrayList<IWizardDescriptor>();
            this.fillWizards(root, wizards);
            primary = wizards.toArray(new IWizardDescriptor[wizards.size()]);
        }
        this.mainPage = new NewWizardSelectionPage(this.workbench, this.selection, root, primary, this.projectsOnly);
        this.addPage((IWizardPage)this.mainPage);
    }

    private void fillWizards(IWizardCategory root, List<IWizardDescriptor> wizards) {
        IWizardDescriptor[] iWizardDescriptorArray = root.getWizards();
        int n = iWizardDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizardDescriptor = iWizardDescriptorArray[n2];
            if (wizardDescriptor.getId().toLowerCase().indexOf(ZEND) >= 0 && (wizardDescriptor.getCategory() == null || wizardDescriptor.getCategory().getId().toLowerCase().indexOf(EXAMPLE) < 0)) {
                wizards.add(wizardDescriptor);
            }
            ++n2;
        }
        iWizardDescriptorArray = root.getCategories();
        n = iWizardDescriptorArray.length;
        n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizardCategory = iWizardDescriptorArray[n2];
            this.fillWizards((IWizardCategory)wizardCategory, wizards);
            ++n2;
        }
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    private IWizardCategory getChildWithID(IWizardCategory parent, String id) {
        IWizardCategory[] children = parent.getCategories();
        int i = 0;
        while (i < children.length) {
            IWizardCategory currentChild = children[i];
            if (currentChild.getId().equals(id)) {
                return currentChild;
            }
            ++i;
        }
        return null;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.workbench = aWorkbench;
        this.selection = currentSelection;
        if (this.getWindowTitle() == null) {
            if (this.projectsOnly) {
                this.setWindowTitle(WorkbenchMessages.NewProject_title);
            } else {
                this.setWindowTitle(WorkbenchMessages.NewWizard_title);
            }
        }
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_NEW_WIZ"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.mainPage.saveWidgetValues();
        if (this.getContainer().getCurrentPage() == this.mainPage && this.mainPage.canFinishEarly()) {
            IWizard wizard = this.mainPage.getSelectedNode().getWizard();
            wizard.setContainer(this.getContainer());
            return wizard.performFinish();
        }
        return true;
    }

    public void setCategoryId(String id) {
        this.categoryId = id;
    }

    public void setProjectsOnly(boolean b) {
        this.projectsOnly = b;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.mainPage && this.mainPage.canFinishEarly()) {
            return true;
        }
        return super.canFinish();
    }
}

