/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.contexts.ClassMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassObjMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassStaticMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.TraitUtils;
import org.eclipse.php.internal.core.typeinference.UseTrait;

public abstract class ClassMembersStrategy
extends AbstractCompletionStrategy {
    ClassStaticMemberContext staticMemberContext;
    boolean isFunctionParameterContext = false;

    public ClassMembersStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassMembersStrategy(ICompletionContext context) {
        super(context);
        if (context instanceof ClassStaticMemberContext) {
            this.staticMemberContext = (ClassStaticMemberContext)context;
            this.isFunctionParameterContext = this.staticMemberContext.isFunctionParameterContext();
        }
    }

    protected boolean showStaticMembers(ClassMemberContext context) {
        return context.getTriggerType() == ClassMemberContext.Trigger.CLASS || context.getPHPVersion().isGreaterThan(PHPVersion.PHP5);
    }

    protected boolean showNonStaticMembers(ClassMemberContext context) {
        return context.getTriggerType() == ClassMemberContext.Trigger.OBJECT || this.isParentCall(context);
    }

    protected boolean isThisCall(ClassMemberContext context) {
        return context instanceof ClassObjMemberContext && ((ClassObjMemberContext)context).isThis();
    }

    protected boolean isDirectThis(ClassMemberContext context) {
        return context instanceof ClassObjMemberContext && ((ClassObjMemberContext)context).isDirectThis();
    }

    protected boolean isSelfCall(ClassMemberContext context) {
        return context instanceof ClassStaticMemberContext && ((ClassStaticMemberContext)context).isSelf();
    }

    protected boolean isDirectSelfCall(ClassMemberContext context) {
        return context instanceof ClassStaticMemberContext && ((ClassStaticMemberContext)context).isDirectSelf();
    }

    protected boolean isParentCall(ClassMemberContext context) {
        return context instanceof ClassStaticMemberContext && ((ClassStaticMemberContext)context).isParent();
    }

    protected boolean isDirectParentCall(ClassMemberContext context) {
        return context instanceof ClassStaticMemberContext && ((ClassStaticMemberContext)context).isDirectParent();
    }

    protected boolean showStrictOptions() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistShowStrictOptions", false, null);
    }

    protected boolean isVisible(IMember member, ClassMemberContext context) throws ModelException {
        if (this.isThisCall(context) || this.isSelfCall(context)) {
            return true;
        }
        int flags = member.getFlags();
        if (this.isParentCall(context)) {
            return !PHPFlags.isPrivate((int)flags);
        }
        return !PHPFlags.isPrivate((int)flags) && !PHPFlags.isProtected((int)flags);
    }

    protected boolean isFiltered(IMember member, IType type, ClassMemberContext context) throws ModelException {
        int flags = member.getFlags();
        if (PHPFlags.isConstant(member.getFlags())) {
            if (context.getTriggerType() == ClassMemberContext.Trigger.CLASS) {
                if (PHPFlags.isPrivate((int)flags) && member.getDeclaringType().equals(type) && !this.isTraitMember(context.getPHPVersion(), type, member)) {
                    if (this.isParent(context)) {
                        return true;
                    }
                    if (this.isSelfKeyword(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromInsideClass(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromOutsideClass(context)) {
                        return true;
                    }
                } else if (PHPFlags.isProtected((int)flags)) {
                    if (this.isParent(context)) {
                        return false;
                    }
                    if (this.isSelfKeyword(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromInsideClass(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromOutsideClass(context)) {
                        return true;
                    }
                } else if (PHPFlags.isPublic((int)flags)) {
                    return false;
                }
            } else if (context.getTriggerType() == ClassMemberContext.Trigger.OBJECT) {
                return true;
            }
        } else if (PHPFlags.isStatic((int)flags)) {
            if (member instanceof IField) {
                if (context.getTriggerType() == ClassMemberContext.Trigger.CLASS && !this.isFunctionParameterContext) {
                    if (PHPFlags.isPrivate((int)flags) && (member.getDeclaringType().equals(type) || this.isTraitMember(context.getPHPVersion(), type, member))) {
                        if (this.isParent(context)) {
                            return true;
                        }
                        if (this.isSelfKeyword(context)) {
                            return false;
                        }
                        if (this.isStaticAccessFromInsideClass(context)) {
                            return false;
                        }
                        if (this.isStaticAccessFromOutsideClass(context)) {
                            return true;
                        }
                    } else if (PHPFlags.isProtected((int)flags)) {
                        if (this.isParent(context)) {
                            return false;
                        }
                        if (this.isSelfKeyword(context)) {
                            return false;
                        }
                        if (this.isStaticAccessFromInsideClass(context)) {
                            return false;
                        }
                        if (this.isStaticAccessFromOutsideClass(context)) {
                            return true;
                        }
                    } else if (PHPFlags.isPublic((int)flags)) {
                        return false;
                    }
                } else if (context.getTriggerType() == ClassMemberContext.Trigger.OBJECT) {
                    if (PHPFlags.isPrivate((int)flags) && (member.getDeclaringType().equals(type) || this.isTraitMember(context.getPHPVersion(), type, member))) {
                        if (this.isThisKeyWord(context) && this.showStrictOptions()) {
                            return false;
                        }
                        if (this.isIndirectThis(context)) {
                            return true;
                        }
                        if (this.isSimpleArrow(context)) {
                            return true;
                        }
                    } else if (PHPFlags.isProtected((int)flags)) {
                        if (this.isThisKeyWord(context) && this.showStrictOptions()) {
                            return false;
                        }
                        if (this.isIndirectThis(context) && this.isDirectThis(context)) {
                            return true;
                        }
                        if (this.isSimpleArrow(context)) {
                            return true;
                        }
                    } else if (PHPFlags.isPublic((int)flags)) {
                        if (this.isThisKeyWord(context) && this.showStrictOptions()) {
                            return false;
                        }
                        if (this.isIndirectThis(context) && this.showStrictOptions()) {
                            return false;
                        }
                        if (this.isSimpleArrow(context) && this.showStrictOptions()) {
                            return false;
                        }
                    }
                }
            } else if (member instanceof IMethod) {
                if (context.getTriggerType() == ClassMemberContext.Trigger.CLASS && !this.isFunctionParameterContext) {
                    if (PHPFlags.isPrivate((int)flags) && (member.getDeclaringType().equals(type) || this.isTraitMember(context.getPHPVersion(), type, member))) {
                        if (this.isParent(context)) {
                            return true;
                        }
                        if (this.isSelfCall(context)) {
                            return false;
                        }
                        if (!this.isThisCall(context) && !this.isParentCall(context) && this.isSelfCall(context)) {
                            return false;
                        }
                        if (!(this.isThisCall(context) || this.isParentCall(context) || this.isSelfCall(context))) {
                            return true;
                        }
                    } else if (PHPFlags.isProtected((int)flags)) {
                        if (this.isParent(context)) {
                            return false;
                        }
                        if (this.isSelfCall(context)) {
                            return false;
                        }
                        if (!this.isThisCall(context) && !this.isParentCall(context) && this.isSelfCall(context)) {
                            return false;
                        }
                        if (!(this.isThisCall(context) || this.isParentCall(context) || this.isSelfCall(context))) {
                            return true;
                        }
                    } else if (PHPFlags.isPublic((int)flags)) {
                        if (this.isParent(context)) {
                            return false;
                        }
                        if (this.isSelfCall(context)) {
                            return false;
                        }
                        if (!this.isThisCall(context) && !this.isParentCall(context) && this.isSelfCall(context)) {
                            return false;
                        }
                        if (!this.isThisCall(context) && !this.isParentCall(context)) {
                            return false;
                        }
                    } else if (PHPFlags.isDefault(flags)) {
                        if (this.isParent(context)) {
                            return false;
                        }
                        if (this.isSelfCall(context)) {
                            return false;
                        }
                        if (!this.isThisCall(context) && !this.isParentCall(context) && this.isSelfCall(context)) {
                            return false;
                        }
                        if (!this.isThisCall(context) && !this.isParentCall(context)) {
                            return false;
                        }
                    }
                } else if (context.getTriggerType() == ClassMemberContext.Trigger.OBJECT) {
                    if (PHPFlags.isPrivate((int)flags) && (member.getDeclaringType().equals(type) || this.isTraitMember(context.getPHPVersion(), type, member))) {
                        if (this.isThisKeyWord(context)) {
                            return false;
                        }
                        if (this.isIndirectThis(context)) {
                            return false;
                        }
                        if (this.isSimpleArrow(context)) {
                            return true;
                        }
                    } else if (PHPFlags.isProtected((int)flags)) {
                        if (this.isThisKeyWord(context)) {
                            return false;
                        }
                        if (this.isIndirectThis(context)) {
                            return false;
                        }
                        if (this.isSimpleArrow(context)) {
                            return true;
                        }
                    } else if (PHPFlags.isPublic((int)flags)) {
                        if (this.isThisKeyWord(context)) {
                            return false;
                        }
                        if (this.isIndirectThis(context)) {
                            return false;
                        }
                        if (this.isSimpleArrow(context)) {
                            return false;
                        }
                    } else if (PHPFlags.isDefault(flags)) {
                        if (this.isThisKeyWord(context)) {
                            return false;
                        }
                        if (this.isIndirectThis(context)) {
                            return false;
                        }
                        if (this.isSimpleArrow(context)) {
                            return false;
                        }
                    }
                }
            }
        } else if (member instanceof IField) {
            if (context.getTriggerType() == ClassMemberContext.Trigger.CLASS && !this.isFunctionParameterContext) {
                return true;
            }
            if (context.getTriggerType() == ClassMemberContext.Trigger.OBJECT) {
                if (PHPFlags.isPrivate((int)flags) && (member.getDeclaringType().equals(type) || this.isTraitMember(context.getPHPVersion(), type, member))) {
                    if (this.isThisKeyWord(context)) {
                        return false;
                    }
                    if (this.isIndirectThis(context)) {
                        return false;
                    }
                    if (this.isSimpleArrow(context)) {
                        return true;
                    }
                } else if (PHPFlags.isProtected((int)flags)) {
                    if (this.isThisKeyWord(context)) {
                        return false;
                    }
                    if (this.isIndirectThis(context)) {
                        return false;
                    }
                    if (this.isSimpleArrow(context)) {
                        return true;
                    }
                } else if (PHPFlags.isPublic((int)flags)) {
                    if (this.isThisKeyWord(context)) {
                        return false;
                    }
                    if (this.isIndirectThis(context)) {
                        return false;
                    }
                    if (this.isSimpleArrow(context)) {
                        return false;
                    }
                }
            }
        } else if (member instanceof IMethod) {
            if (context.getTriggerType() == ClassMemberContext.Trigger.CLASS && !this.isFunctionParameterContext) {
                if (PHPFlags.isPrivate((int)flags) && (member.getDeclaringType().equals(type) || this.isTraitMember(context.getPHPVersion(), type, member))) {
                    if (this.isParent(context)) {
                        return true;
                    }
                    if (this.isSelfKeyword(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromInsideClass(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromOutsideClass(context)) {
                        return true;
                    }
                } else if (PHPFlags.isProtected((int)flags)) {
                    if (this.isParent(context)) {
                        return false;
                    }
                    if (this.isSelfKeyword(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromInsideClass(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromOutsideClass(context)) {
                        return true;
                    }
                } else if (PHPFlags.isPublic((int)flags)) {
                    if (this.isParent(context)) {
                        return false;
                    }
                    if (this.isSelfKeyword(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromInsideClass(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromOutsideClass(context) && this.showStrictOptions()) {
                        return false;
                    }
                } else if (PHPFlags.isDefault(flags)) {
                    if (this.isParent(context)) {
                        return false;
                    }
                    if (this.isSelfKeyword(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromInsideClass(context)) {
                        return false;
                    }
                    if (this.isStaticAccessFromOutsideClass(context) && this.showStrictOptions()) {
                        return false;
                    }
                }
            } else if (context.getTriggerType() == ClassMemberContext.Trigger.OBJECT) {
                if (PHPFlags.isPrivate((int)flags) && (member.getDeclaringType().equals(type) || this.isTraitMember(context.getPHPVersion(), type, member))) {
                    if (this.isThisKeyWord(context)) {
                        return false;
                    }
                    if (this.isIndirectThis(context)) {
                        return false;
                    }
                    if (this.isSimpleArrow(context)) {
                        return true;
                    }
                } else if (PHPFlags.isProtected((int)flags)) {
                    if (this.isThisKeyWord(context)) {
                        return false;
                    }
                    if (this.isIndirectThis(context)) {
                        return false;
                    }
                    if (this.isSimpleArrow(context)) {
                        return true;
                    }
                } else if (PHPFlags.isPublic((int)flags)) {
                    if (this.isThisKeyWord(context)) {
                        return false;
                    }
                    if (this.isIndirectThis(context)) {
                        return false;
                    }
                    if (this.isSimpleArrow(context)) {
                        return false;
                    }
                } else if (PHPFlags.isDefault(flags)) {
                    if (this.isThisKeyWord(context)) {
                        return false;
                    }
                    if (this.isIndirectThis(context)) {
                        return false;
                    }
                    if (this.isSimpleArrow(context)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isTraitMember(PHPVersion phpVersion, IType type, IMember member) {
        return this.isTraitMember(phpVersion, type, member, new HashSet<IType>());
    }

    private boolean isTraitMember(PHPVersion phpVersion, IType type, IMember member, Set<IType> typeSet) {
        if (phpVersion.isGreaterThan(PHPVersion.PHP5_3)) {
            UseTrait useTrait = TraitUtils.parse(type);
            String typeName = PHPModelUtils.getFullName(member.getDeclaringType());
            for (String trait : useTrait.getTraits()) {
                if (!trait.equals(typeName)) continue;
                return true;
            }
            for (String trait : useTrait.getTraits()) {
                IType[] traits;
                IType[] iTypeArray = traits = PHPModelAccess.getDefault().findTraits(trait, ISearchEngine.MatchRule.EXACT, 0, 0, TraitUtils.createSearchScope(type), null);
                if (traits.length == 0) continue;
                IType traitType = iTypeArray[0];
                return this.isTraitMember(phpVersion, traitType, member, typeSet);
            }
        }
        return false;
    }

    private boolean isParent(ClassMemberContext context) {
        return !this.isThisCall(context) && this.isParentCall(context) && this.isDirectParentCall(context);
    }

    private boolean isSelfKeyword(ClassMemberContext context) {
        return !this.isThisCall(context) && !this.isParentCall(context) && this.isSelfCall(context) && this.isDirectSelfCall(context);
    }

    private boolean isStaticAccessFromInsideClass(ClassMemberContext context) {
        return !this.isThisCall(context) && !this.isParentCall(context) && this.isSelfCall(context) && !this.isDirectSelfCall(context);
    }

    private boolean isStaticAccessFromOutsideClass(ClassMemberContext context) {
        return !this.isThisCall(context) && !this.isParentCall(context) && !this.isSelfCall(context) && !this.isDirectSelfCall(context);
    }

    private boolean isThisKeyWord(ClassMemberContext context) {
        return this.isThisCall(context) && this.isDirectThis(context);
    }

    private boolean isIndirectThis(ClassMemberContext context) {
        return this.isThisCall(context) && !this.isDirectThis(context);
    }

    private boolean isSimpleArrow(ClassMemberContext context) {
        return !this.isThisCall(context) && !this.isDirectThis(context);
    }

    protected <T extends IMember> Collection<T> removeOverriddenElements(Collection<T> members) {
        LinkedList<IMember> result = new LinkedList<IMember>();
        ArrayList<T> newMembers = new ArrayList<T>();
        newMembers.addAll(members);
        Collections.sort(newMembers, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                try {
                    int flag1 = this.getFlag(o1.getFlags());
                    int flag2 = this.getFlag(o2.getFlags());
                    return flag2 - flag1;
                }
                catch (ModelException modelException) {
                    return 0;
                }
            }

            private int getFlag(int flags) {
                if (Flags.isPublic((int)flags)) {
                    return 64;
                }
                if (Flags.isProtected((int)flags)) {
                    return 32;
                }
                if (Flags.isPrivate((int)flags)) {
                    return 16;
                }
                return 16;
            }
        });
        HashSet<String> processed = new HashSet<String>();
        for (IMember member : newMembers) {
            if (!processed.add(member.getElementName())) continue;
            result.add(member);
        }
        return result;
    }
}

