/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEvaluationStepper;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEvaluationVisitor;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMModelManager;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMNestedEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationStepper;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMExecutor;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.internal.evaluation.BasicOCLExecutor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.evaluation.OCLEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class OCLVMExecutor
extends BasicOCLExecutor
implements VMExecutor {
    protected final @NonNull IVMContext vmContext;
    protected final @NonNull ExpressionInOCL expressionInOCL;
    protected final @Nullable EObject context;
    private boolean suspendOnStartup = false;
    private long envId = 0L;

    private static @NonNull EObject loadContext(@NonNull EnvironmentFactory environmentFactory, @NonNull URI contextURI) throws IOException {
        EObject eObject = environmentFactory.getResourceSet().getEObject(contextURI, true);
        if (eObject == null) {
            throw new IOException("Nothing loadable as '" + contextURI + "'");
        }
        return eObject;
    }

    private static @NonNull ExpressionInOCL loadExpression(@NonNull EnvironmentFactory environmentFactory, @NonNull URI constraintURI, boolean keepDebug) throws IOException, ParserException {
        MetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        EObject eObject = metamodelManager.getASResourceSet().getEObject(constraintURI, true);
        return OCLVMExecutor.loadExpression(environmentFactory, eObject, constraintURI);
    }

    private static @NonNull ExpressionInOCL loadExpression(@NonNull EnvironmentFactory environmentFactory, EObject eObject, URI constraintURI) throws IOException, ParserException {
        if (eObject == null) {
            throw new IOException("Nothing loadable as '" + constraintURI + "'");
        }
        if (!(eObject instanceof Constraint)) {
            throw new IOException("Constraint rather than " + eObject.eClass().getName() + " expected as '" + constraintURI + "'");
        }
        LanguageExpression specification = ((Constraint)eObject).getOwnedSpecification();
        if (specification == null) {
            throw new IOException("Missing OCL expression " + eObject.eClass().getName() + " expected as '" + constraintURI + "'");
        }
        MetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        return metamodelManager.parseSpecification(specification);
    }

    public OCLVMExecutor(IVMContext vmContext, @NonNull URI oclURI, @Nullable URI contextURI) throws IOException, ParserException {
        this(vmContext, OCLVMExecutor.loadExpression((EnvironmentFactory)vmContext.getEnvironmentFactory(), oclURI, vmContext.keepDebug()), contextURI != null ? OCLVMExecutor.loadContext((EnvironmentFactory)vmContext.getEnvironmentFactory(), contextURI) : null);
    }

    public OCLVMExecutor(@NonNull IVMContext vmContext, @NonNull ExpressionInOCL expressionInOCL, @Nullable EObject context) {
        super(vmContext.getEnvironmentFactory(), (ModelManager)new OCLVMModelManager((MetamodelManagerInternal)vmContext.getEnvironmentFactory().getMetamodelManager()));
        this.vmContext = vmContext;
        this.expressionInOCL = expressionInOCL;
        this.context = context;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EvaluationVisitor.EvaluationVisitorExtension createEvaluationVisitor() {
        OCLEvaluationVisitor evaluationVisitor = new OCLEvaluationVisitor((ExecutorInternal)this);
        OCLVMEvaluationStepper vmEvaluationStepper = new OCLVMEvaluationStepper(evaluationVisitor, this.vmContext);
        return new OCLVMEvaluationVisitor((VMEvaluationStepper)vmEvaluationStepper, (EvaluationVisitor)evaluationVisitor);
    }

    protected @NonNull OCLVMEvaluationEnvironment createNestedEvaluationEnvironment(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EvaluationEnvironment.EvaluationEnvironmentExtension evaluationEnvironment, @NonNull NamedElement executableObject, @Nullable Object caller) {
        return new OCLVMNestedEvaluationEnvironment((OCLVMEvaluationEnvironment)evaluationEnvironment, executableObject, caller, ++this.envId);
    }

    protected @NonNull OCLVMEvaluationEnvironment createRootEvaluationEnvironment(@NonNull NamedElement executableObject) {
        return new OCLVMRootEvaluationEnvironment(this, (ExpressionInOCL)executableObject, ++this.envId);
    }

    public Object execute() {
        this.initializeEvaluationEnvironment((NamedElement)this.expressionInOCL);
        this.getRootEvaluationEnvironment();
        Variable contextVariable = this.expressionInOCL.getOwnedContext();
        if (contextVariable != null) {
            this.add((TypedElement)contextVariable, this.context);
        }
        OCLVMEvaluationVisitor visitor = (OCLVMEvaluationVisitor)this.getEvaluationVisitor();
        VMEvaluationStepper vmStepper = visitor.getVMEvaluationStepper();
        vmStepper.start(this.suspendOnStartup);
        return this.expressionInOCL.accept((Visitor)visitor);
    }

    public @NonNull ExpressionInOCL getDebuggable() {
        return this.expressionInOCL;
    }

    public @NonNull String getPluginId() {
        return "org.eclipse.ocl.examples.debug";
    }

    public void saveModels() {
    }

    public void setSuspendOnStartUp(boolean suspendOnStartup) {
        this.suspendOnStartup = suspendOnStartup;
    }
}

