/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.commons.sdk.util.JUnitExecutionListener;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.RunnerBuilder;

public class ManagedSuite
extends Suite {
    public static TestConfiguration testConfiguration;

    public static TestConfiguration getTestConfiguration() {
        return testConfiguration;
    }

    public static TestConfiguration getTestConfigurationOrCreateDefault() {
        if (testConfiguration == null) {
            testConfiguration = TestConfiguration.getDefault();
        }
        return testConfiguration;
    }

    public static void setTestConfiguration(TestConfiguration testConfiguration) {
        ManagedSuite.testConfiguration = testConfiguration;
    }

    public ManagedSuite(Class<?> klass, RunnerBuilder builder) throws Throwable {
        super(klass, builder.runners(klass, (Class[])ManagedSuite.getSuiteClasses(klass, klass.getClasses())));
    }

    private static Class<?>[] getSuiteClasses(Class<?> klass, Class<?>[] classes) throws SecurityException {
        ArrayList<Class> suiteClassList = new ArrayList<Class>();
        Object[] objectArray = klass.getAnnotations();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = objectArray[n2];
            if (annotation.annotationType() == TestConfigurationProperty.class) {
                if (ManagedSuite.getTestConfiguration() == null) {
                    TestConfigurationProperty configurationProperty = (TestConfigurationProperty)annotation;
                    TestConfiguration testConfiguration = new TestConfiguration();
                    testConfiguration.setLocalOnly(configurationProperty.localOnly());
                    testConfiguration.setDefaultOnly(configurationProperty.defaultOnly());
                    testConfiguration.setHeadless(configurationProperty.headless());
                    ManagedSuite.setTestConfiguration(testConfiguration);
                }
            } else if (annotation.annotationType() == Suite.SuiteClasses.class) {
                Suite.SuiteClasses suiteClasses = (Suite.SuiteClasses)annotation;
                Class[] classArray = suiteClasses.value();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class suiteClass = classArray[n4];
                    suiteClassList.add(suiteClass);
                    ++n4;
                }
            }
            ++n2;
        }
        if (ManagedSuite.getTestConfiguration() == null) {
            ManagedSuite.setTestConfiguration(TestConfiguration.getDefault());
        }
        objectArray = klass.getDeclaredMethods();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object method = objectArray[n2];
            if (((AccessibleObject)method).isAnnotationPresent(SuiteClassProvider.class)) {
                try {
                    TestConfiguration conf = ManagedSuite.getTestConfiguration();
                    Parameter[] parameters = ((Executable)method).getParameters();
                    if (parameters.length == 2 && parameters[0].getType() == List.class && parameters[1].getType() == TestConfiguration.class && Modifier.isStatic(((Method)method).getModifiers())) {
                        if (!Modifier.isPublic(((Method)method).getModifiers())) {
                            ((Method)method).setAccessible(true);
                        }
                        ((Method)method).invoke(null, suiteClassList, conf);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return suiteClassList.toArray(new Class[suiteClassList.size()]);
    }

    public void run(RunNotifier notifier) {
        JUnitExecutionListener listener = JUnitExecutionListener.getDefault();
        if (listener == null) {
            notifier.addListener((RunListener)JUnitExecutionListener.createDefault());
        }
        super.run(notifier);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface SuiteClassProvider {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TestConfigurationProperty {
        public boolean localOnly() default false;

        public boolean defaultOnly() default false;

        public boolean headless() default false;
    }
}

