/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jaxrs.internal.configurators;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.facets.AbstractFacetDetector;
import org.eclipse.m2e.wtp.jaxrs.internal.MavenJaxRsConstants;
import org.eclipse.m2e.wtp.jaxrs.internal.Messages;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathJaxRsFacetDetector
extends AbstractFacetDetector {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathJaxRsFacetDetector.class);

    public IProjectFacetVersion findFacetVersion(IMavenProjectFacade mavenProjectFacade, Map<?, ?> context, IProgressMonitor monitor) {
        IProject project = mavenProjectFacade.getProject();
        if (project == null) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IType type = null;
            try {
                type = javaProject.findType("javax.ws.rs.client.Client");
                if (type != null) {
                    return MavenJaxRsConstants.JAX_RS_FACET_2_0;
                }
                type = javaProject.findType("javax.ws.rs.ApplicationPath");
                if (type != null) {
                    return MavenJaxRsConstants.JAX_RS_FACET_1_1;
                }
                type = javaProject.findType("javax.ws.rs.Path");
                if (type != null) {
                    return MavenJaxRsConstants.JAX_RS_FACET_1_0;
                }
            }
            catch (JavaModelException e) {
                LOG.error(Messages.ClasspathJaxRsFacetDetector_Unable_To_Determine_JAXRS_Version, (Throwable)e);
            }
        }
        return null;
    }
}

