/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.lsp4e.DocumentContentSynchronizer;
import org.eclipse.lsp4e.FileBufferListenerAdapter;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeLensCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.DocumentHighlightCapabilities;
import org.eclipse.lsp4j.DocumentLinkCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SymbolCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ProjectSpecificLanguageServerWrapper {
    private IFileBufferListener fileBufferListener = new FileBufferListenerAdapter(){

        @Override
        public void bufferDisposed(IFileBuffer buffer) {
            Path filePath = new Path(buffer.getFileStore().toURI().getPath());
            if (!this.isFromProject((IPath)filePath)) {
                return;
            }
            ProjectSpecificLanguageServerWrapper.this.disconnect((IPath)filePath);
        }

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (isDirty) {
                return;
            }
            Path filePath = new Path(buffer.getFileStore().toURI().getPath());
            if (!this.isFromProject((IPath)filePath)) {
                return;
            }
            DocumentContentSynchronizer documentListener = (DocumentContentSynchronizer)ProjectSpecificLanguageServerWrapper.this.connectedDocuments.get(filePath);
            if (documentListener != null && documentListener.getModificationStamp() < buffer.getModificationStamp()) {
                documentListener.documentSaved(buffer.getModificationStamp());
            }
        }

        private boolean isFromProject(IPath path) {
            if (ProjectSpecificLanguageServerWrapper.this.project == null || ProjectSpecificLanguageServerWrapper.this.project.getLocation() == null) {
                return false;
            }
            return ProjectSpecificLanguageServerWrapper.this.project.getLocation().isPrefixOf(path);
        }
    };
    public final  @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition;
    public final @NonNull IProject project;
    private final @NonNull StreamConnectionProvider lspStreamProvider;
    private LanguageServer languageServer;
    private Map<IPath, DocumentContentSynchronizer> connectedDocuments;
    private InitializeResult initializeResult;
    private Future<?> launcherFuture;
    private CompletableFuture<InitializeResult> initializeFuture;
    private boolean capabilitiesAlreadyRequested;
    private long initializeStartTime;

    public ProjectSpecificLanguageServerWrapper(@NonNull IProject project,  @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) {
        this.project = project;
        this.serverDefinition = serverDefinition;
        this.lspStreamProvider = serverDefinition.createConnectionProvider();
        this.connectedDocuments = new HashMap<IPath, DocumentContentSynchronizer>();
    }

    public synchronized void start() throws IOException {
        Map<IPath, IDocument> filesToReconnect = Collections.emptyMap();
        if (this.languageServer != null) {
            if (this.isActive()) {
                return;
            }
            filesToReconnect = new HashMap();
            for (Map.Entry<IPath, DocumentContentSynchronizer> entry : this.connectedDocuments.entrySet()) {
                filesToReconnect.put(entry.getKey(), entry.getValue().getDocument());
            }
            this.stop();
        }
        try {
            this.lspStreamProvider.start();
            LanguageClientImpl client = this.serverDefinition.createLanguageClient();
            ExecutorService executorService = Executors.newCachedThreadPool();
            InitializeParams initParams = new InitializeParams();
            initParams.setRootUri(LSPEclipseUtils.toUri((IResource)this.project).toString());
            initParams.setRootPath(this.project.getLocation().toFile().getAbsolutePath());
            Launcher launcher = Launcher.createLauncher((Object)client, this.serverDefinition.getServerInterface(), (InputStream)this.lspStreamProvider.getInputStream(), (OutputStream)this.lspStreamProvider.getOutputStream(), (ExecutorService)executorService, consumer -> message -> {
                consumer.consume(message);
                this.logMessage(message);
                this.lspStreamProvider.handleMessage(message, this.languageServer, URI.create(initParams.getRootUri()));
            });
            this.languageServer = (LanguageServer)launcher.getRemoteProxy();
            client.connect(this.languageServer, this);
            this.launcherFuture = launcher.startListening();
            String name = "Eclipse IDE";
            if (Platform.getProduct() != null) {
                name = Platform.getProduct().getName();
            }
            WorkspaceClientCapabilities workspaceClientCapabilites = new WorkspaceClientCapabilities();
            workspaceClientCapabilites.setApplyEdit(Boolean.TRUE);
            workspaceClientCapabilites.setExecuteCommand(new ExecuteCommandCapabilities());
            workspaceClientCapabilites.setSymbol(new SymbolCapabilities());
            TextDocumentClientCapabilities textDocumentClientCapabilities = new TextDocumentClientCapabilities();
            textDocumentClientCapabilities.setCodeAction(new CodeActionCapabilities());
            textDocumentClientCapabilities.setCodeLens(new CodeLensCapabilities());
            textDocumentClientCapabilities.setCompletion(new CompletionCapabilities(new CompletionItemCapabilities(Boolean.TRUE)));
            textDocumentClientCapabilities.setDefinition(new DefinitionCapabilities());
            textDocumentClientCapabilities.setDocumentHighlight(new DocumentHighlightCapabilities());
            textDocumentClientCapabilities.setDocumentLink(new DocumentLinkCapabilities());
            textDocumentClientCapabilities.setDocumentSymbol(new DocumentSymbolCapabilities());
            textDocumentClientCapabilities.setFormatting(new FormattingCapabilities());
            textDocumentClientCapabilities.setHover(new HoverCapabilities());
            textDocumentClientCapabilities.setOnTypeFormatting(null);
            textDocumentClientCapabilities.setRangeFormatting(new RangeFormattingCapabilities());
            textDocumentClientCapabilities.setReferences(new ReferencesCapabilities());
            textDocumentClientCapabilities.setRename(new RenameCapabilities());
            textDocumentClientCapabilities.setSignatureHelp(new SignatureHelpCapabilities());
            textDocumentClientCapabilities.setSynchronization(new SynchronizationCapabilities(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE));
            initParams.setCapabilities(new ClientCapabilities(workspaceClientCapabilites, textDocumentClientCapabilities, null));
            initParams.setClientName(name);
            initParams.setInitializationOptions(this.lspStreamProvider.getInitializationOptions(URI.create(initParams.getRootUri())));
            this.initializeFuture = this.languageServer.initialize(initParams).thenApply(res -> {
                this.initializeResult = res;
                return res;
            });
            this.initializeStartTime = System.currentTimeMillis();
            Map<IPath, IDocument> toReconnect = filesToReconnect;
            this.initializeFuture.thenRun(() -> {
                for (Map.Entry fileToReconnect : toReconnect.entrySet()) {
                    try {
                        this.connect((IPath)fileToReconnect.getKey(), (IDocument)fileToReconnect.getValue());
                    }
                    catch (IOException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }
            });
            FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
            this.stop();
        }
    }

    private void logMessage(Message message) {
        if (message instanceof ResponseMessage && ((ResponseMessage)message).getError() != null) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            LanguageServerPlugin.logError((Throwable)new ResponseErrorException(responseMessage.getError()));
        } else if (LanguageServerPlugin.DEBUG) {
            LanguageServerPlugin.logInfo(String.valueOf(message.getClass().getSimpleName()) + '\n' + message.toString());
        }
    }

    public boolean isActive() {
        return this.launcherFuture != null && !this.launcherFuture.isDone() && !this.launcherFuture.isCancelled();
    }

    private synchronized void stop() {
        if (this.initializeFuture != null) {
            this.initializeFuture.cancel(true);
            this.initializeFuture = null;
        }
        this.initializeResult = null;
        this.capabilitiesAlreadyRequested = false;
        if (this.languageServer != null) {
            try {
                CompletableFuture shutdown = this.languageServer.shutdown();
                shutdown.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.launcherFuture != null) {
            this.launcherFuture.cancel(true);
            this.launcherFuture = null;
        }
        if (this.lspStreamProvider != null) {
            this.lspStreamProvider.stop();
        }
        while (!this.connectedDocuments.isEmpty()) {
            this.disconnect(this.connectedDocuments.keySet().iterator().next());
        }
        this.languageServer = null;
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
    }

    public void connect(@NonNull IPath absolutePath, IDocument document) throws IOException {
        IPath thePath = Path.fromOSString((String)absolutePath.toFile().getAbsolutePath());
        if (this.connectedDocuments.containsKey(thePath)) {
            return;
        }
        this.start();
        if (this.initializeFuture == null) {
            return;
        }
        if (document == null) {
            IFile file = (IFile)LSPEclipseUtils.findResourceFor(thePath.toFile().toURI().toString());
            document = LSPEclipseUtils.getDocument((IResource)file);
        }
        if (document == null) {
            return;
        }
        IDocument theDocument = document;
        this.initializeFuture.thenRun(() -> {
            if (this.connectedDocuments.containsKey(thePath)) {
                return;
            }
            Either syncOptions = this.initializeFuture == null ? null : this.initializeResult.getCapabilities().getTextDocumentSync();
            TextDocumentSyncKind syncKind = null;
            if (syncOptions != null) {
                if (syncOptions.isRight()) {
                    syncKind = ((TextDocumentSyncOptions)syncOptions.getRight()).getChange();
                } else if (syncOptions.isLeft()) {
                    syncKind = (TextDocumentSyncKind)syncOptions.getLeft();
                }
            }
            DocumentContentSynchronizer listener = new DocumentContentSynchronizer(this, theDocument, thePath, syncKind);
            theDocument.addDocumentListener((IDocumentListener)listener);
            this.connectedDocuments.put(thePath, listener);
        });
    }

    public void disconnect(IPath path) {
        DocumentContentSynchronizer documentListener = this.connectedDocuments.remove(path);
        if (documentListener != null) {
            documentListener.getDocument().removeDocumentListener((IDocumentListener)documentListener);
            documentListener.documentClosed();
        }
        if (this.connectedDocuments.isEmpty()) {
            this.stop();
        }
    }

    public boolean isConnectedTo(IPath location) {
        return this.connectedDocuments.containsKey(location);
    }

    public @Nullable LanguageServer getServer() {
        try {
            this.start();
        }
        catch (IOException ex) {
            LanguageServerPlugin.logError(ex);
        }
        if (this.initializeFuture != null && !this.initializeFuture.isDone()) {
            if (Display.getCurrent() != null) {
                Job waitForInitialization = new Job(Messages.initializeLanguageServer_job){

                    protected IStatus run(IProgressMonitor monitor) {
                        ProjectSpecificLanguageServerWrapper.this.initializeFuture.join();
                        return Status.OK_STATUS;
                    }
                };
                waitForInitialization.setUser(true);
                waitForInitialization.setSystem(false);
                PlatformUI.getWorkbench().getProgressService().showInDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), waitForInitialization);
            } else {
                this.initializeFuture.join();
            }
        }
        return this.languageServer;
    }

    public @Nullable ServerCapabilities getServerCapabilities() {
        try {
            this.start();
            if (this.initializeFuture != null) {
                this.initializeFuture.get(this.capabilitiesAlreadyRequested ? 0 : 1000, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException e) {
            if (System.currentTimeMillis() - this.initializeStartTime > 10000L) {
                LanguageServerPlugin.logError("LanguageServer not initialized after 10s", e);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        this.capabilitiesAlreadyRequested = true;
        if (this.initializeResult != null) {
            return this.initializeResult.getCapabilities();
        }
        return null;
    }

    public @Nullable String getLanguageId(IContentType[] contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            String languageId = this.serverDefinition.langugeIdMappings.get(contentType);
            if (languageId != null) {
                return languageId;
            }
            ++n2;
        }
        return null;
    }
}

