/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServiceAccessor;

public class ConnectDocumentToLanguageServerSetupParticipant
implements IDocumentSetupParticipant,
IDocumentSetupParticipantExtension {
    public void setup(IDocument document) {
        ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(document);
        if (buffer == null || buffer.getLocation() == null) {
            return;
        }
        this.setup(document, buffer.getLocation(), LocationKind.IFILE);
    }

    public void setup(final IDocument document, IPath location, LocationKind locationKind) {
        Job job = new Job("Initialize Language Servers for " + location.toFile().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> Boolean.TRUE);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(10);
        job.schedule(100L);
    }

    private static final class DocumentInputStream
    extends InputStream {
        private int index = 0;
        private IDocument document;

        DocumentInputStream(IDocument document) {
            this.document = document;
        }

        @Override
        public int read() throws IOException {
            if (this.index < this.document.getLength()) {
                try {
                    char res = this.document.getChar(this.index);
                    ++this.index;
                    return res;
                }
                catch (BadLocationException e) {
                    throw new IOException(e);
                }
            }
            return -1;
        }
    }
}

