/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.QuotedString;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StopOptionHandler;

@Command(common=true, usage="usage_LsTree")
class LsTree
extends TextBuiltin {
    @Option(name="--recursive", usage="usage_recurseIntoSubtrees", aliases={"-r"})
    private boolean recursive;
    @Argument(index=0, required=true, metaVar="metaVar_treeish")
    private AbstractTreeIterator tree;
    @Argument(index=1)
    @Option(name="--", metaVar="metaVar_paths", handler=StopOptionHandler.class)
    private List<String> paths = new ArrayList<String>();

    LsTree() {
    }

    @Override
    protected void run() throws Exception {
        try (TreeWalk walk = new TreeWalk(this.db);){
            walk.reset();
            if (this.paths.size() > 0) {
                walk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            walk.setRecursive(this.recursive);
            walk.addTree(this.tree);
            while (walk.next()) {
                FileMode mode = walk.getFileMode(0);
                if (mode == FileMode.TREE) {
                    this.outw.print('0');
                }
                this.outw.print((Object)mode);
                this.outw.print(' ');
                this.outw.print((Object)Constants.typeString((int)mode.getObjectType()));
                this.outw.print(' ');
                this.outw.print((Object)walk.getObjectId(0).name());
                this.outw.print('\t');
                this.outw.print((Object)QuotedString.GIT_PATH.quote(walk.getPathString()));
                this.outw.println();
            }
        }
    }
}

