/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.layout.Region;
import org.eclipse.fx.core.text.DefaultContent;
import org.eclipse.fx.core.text.TextContent;
import org.eclipse.fx.ui.controls.styledtext_ng.StyleRange;
import org.eclipse.fx.ui.controls.styledtext_ng.internal.ContentArea;
import org.eclipse.fx.ui.controls.styledtext_ng.internal.StyledTextRenderer;
import org.eclipse.jdt.annotation.Nullable;

public class StyledTextAreaNG
extends Region {
    private final ObjectProperty<TextContent> content = new SimpleObjectProperty((Object)this, "content", (Object)new DefaultContent());
    private final StyledTextRenderer renderer = new StyledTextRenderer();
    private final ContentArea contentArea = new ContentArea(this);

    public final ObjectProperty<TextContent> contentProperty() {
        return this.content;
    }

    public final TextContent getContent() {
        return (TextContent)this.contentProperty().get();
    }

    public final void setContent(TextContent content) {
        this.contentProperty().set((Object)content);
    }

    public void setStyleRange(@Nullable StyleRange range) {
        if (range != null) {
            if (range.isUnstyled()) {
                this.setStyleRanges(range.start, range.length, null, null, false);
            } else {
                this.setStyleRanges(range.start, 0, null, new StyleRange[]{range}, false);
            }
        } else {
            this.setStyleRanges(0, 0, null, null, true);
        }
    }

    public void setStyleRanges(int start, int length, int[] ranges, @Nullable StyleRange[] styles) {
        if (ranges == null || styles == null) {
            this.setStyleRanges(start, length, null, null, false);
        } else {
            this.setStyleRanges(start, length, ranges, styles, false);
        }
    }

    public void setStyleRanges(int[] ranges, @Nullable StyleRange[] styles) {
        if (ranges == null || styles == null) {
            this.setStyleRanges(0, 0, null, null, true);
        } else {
            this.setStyleRanges(0, 0, ranges, styles, true);
        }
    }

    public void setStyleRanges(StyleRange ... ranges) {
        this.setStyleRanges(0, 0, null, ranges, true);
    }

    public void replaceStyleRanges(int start, int length, @Nullable StyleRange[] ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException();
        }
        this.setStyleRanges(start, length, null, ranges, false);
    }

    void setStyleRanges(int start, int length, int[] ranges, StyleRange[] styles, boolean reset) {
        int charCount = this.getContent().getCharCount();
        int end = start + length;
        if (start > end || start < 0) {
            throw new IllegalArgumentException();
        }
        if (styles != null) {
            if (end > charCount) {
                throw new IllegalArgumentException();
            }
            if (ranges != null && ranges.length != styles.length << 1) {
                throw new IllegalArgumentException();
            }
            int lastOffset = 0;
            int i = 0;
            while (i < styles.length) {
                int rangeLength;
                int rangeStart;
                if (styles[i] == null) {
                    throw new IllegalArgumentException();
                }
                if (ranges != null) {
                    rangeStart = ranges[i << 1];
                    rangeLength = ranges[(i << 1) + 1];
                } else {
                    rangeStart = styles[i].start;
                    rangeLength = styles[i].length;
                }
                if (rangeLength < 0) {
                    throw new IllegalArgumentException();
                }
                if (rangeStart < 0 || rangeStart + rangeLength > charCount) {
                    throw new IllegalArgumentException();
                }
                if (lastOffset > rangeStart) {
                    throw new IllegalArgumentException();
                }
                lastOffset = rangeStart + rangeLength;
                ++i;
            }
        }
        int rangeStart = start;
        int rangeEnd = end;
        if (styles != null && styles.length > 0) {
            if (ranges != null) {
                rangeStart = ranges[0];
                rangeEnd = ranges[ranges.length - 2] + ranges[ranges.length - 1];
            } else {
                rangeStart = styles[0].start;
                rangeEnd = styles[styles.length - 1].start + styles[styles.length - 1].length;
            }
        }
        if (reset) {
            this.renderer.setStyleRanges(null, null);
        } else {
            this.renderer.updateRanges(start, length, length);
        }
        if (styles != null && styles.length > 0) {
            this.renderer.setStyleRanges(ranges, styles);
        }
        this.contentArea.refreshStyleRanges(start, length);
    }
}

