/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.form;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.ui.controls.form.DecoratedNode;
import org.eclipse.fx.ui.controls.form.NodeDecorator;
import org.osgi.service.component.annotations.Component;

@Component
public class GraphicDecorator
implements NodeDecorator {
    static final String BASE_STYLESHEET = GraphicDecorator.class.getResource("graphic-status-decorator.css").toExternalForm();
    private Location location;

    public GraphicDecorator() {
        this(Location.TOP_LEFT);
    }

    public GraphicDecorator(Location location) {
        this.location = location;
    }

    @Override
    public DecoratedNode decorate(Node node) {
        if (node instanceof Control) {
            return new GraphicDecoratedControl((Control)node, this.location);
        }
        throw new IllegalArgumentException("Unable to decorate '" + node + "'");
    }

    static class GraphicDecoratedControl
    implements DecoratedNode {
        private final Label icon;
        private final ObjectProperty<Status> statusProperty = new SimpleObjectProperty((Object)this, "status", (Object)Status.ok());
        private static PseudoClass error = PseudoClass.getPseudoClass((String)"error");
        private static PseudoClass warning = PseudoClass.getPseudoClass((String)"warning");
        private static PseudoClass ok = PseudoClass.getPseudoClass((String)"ok");
        private static PseudoClass cancel = PseudoClass.getPseudoClass((String)"cancel");

        public GraphicDecoratedControl(Control c, Location location) {
            this.icon = new Label(){

                public String getUserAgentStylesheet() {
                    return BASE_STYLESHEET;
                }
            };
            this.icon.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.icon.getStyleClass().add((Object)"status-decorator-icon");
            this.icon.setManaged(false);
            if (c.getSkin() != null) {
                ((SkinBase)c.getSkin()).getChildren().add((Object)this.icon);
            }
            c.skinProperty().addListener((ob, ol, ne) -> {
                if (ol != null) {
                    ((SkinBase)ol).getChildren().remove((Object)this.icon);
                }
                if (ne != null) {
                    ((SkinBase)ne).getChildren().add((Object)this.icon);
                }
            });
            if (location == Location.TOP_LEFT) {
                this.icon.layoutXProperty().bind((ObservableValue)this.icon.widthProperty().divide(-2));
                this.icon.layoutYProperty().bind((ObservableValue)this.icon.heightProperty().divide(-2));
            } else if (location == Location.TOP_RIGHT) {
                this.icon.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> c.getWidth() - this.icon.widthProperty().get() / 2.0, (Observable[])new Observable[]{this.icon.widthProperty(), c.widthProperty()}));
                this.icon.layoutYProperty().bind((ObservableValue)this.icon.heightProperty().divide(-2));
            } else if (location == Location.BOTTOM_LEFT) {
                this.icon.layoutXProperty().bind((ObservableValue)this.icon.widthProperty().divide(-2));
                this.icon.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> c.getHeight() - this.icon.heightProperty().get() / 2.0, (Observable[])new Observable[]{this.icon.heightProperty(), c.heightProperty()}));
            } else if (location == Location.BOTTOM_RIGHT) {
                this.icon.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> c.getWidth() - this.icon.widthProperty().get() / 2.0, (Observable[])new Observable[]{this.icon.widthProperty(), c.widthProperty()}));
                this.icon.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> c.getHeight() - this.icon.heightProperty().get() / 2.0, (Observable[])new Observable[]{this.icon.heightProperty(), c.heightProperty()}));
            }
            GraphicDecoratedControl.updatePseudoState(this.icon, (Status)this.statusProperty.getValue());
            this.statusProperty.addListener((o, ol, ne) -> GraphicDecoratedControl.updatePseudoState(this.icon, ne));
            this.icon.translateXProperty().addListener(o -> System.err.println(this.icon.translateXProperty().get()));
        }

        private static void updatePseudoState(Label statusIcon, Status status) {
            statusIcon.pseudoClassStateChanged(error, status != null && status.getState() == Status.State.ERROR);
            statusIcon.pseudoClassStateChanged(warning, status != null && status.getState() == Status.State.WARNING);
            statusIcon.pseudoClassStateChanged(ok, status == null || status.getState() == Status.State.OK);
            statusIcon.pseudoClassStateChanged(cancel, status != null && status.getState() == Status.State.CANCEL);
            statusIcon.autosize();
            if (statusIcon.getTooltip() == null) {
                if (status != null && status.getState() != Status.State.OK) {
                    statusIcon.setTooltip(new Tooltip(status.getMessage()));
                }
            } else {
                statusIcon.getTooltip().setText(status == null ? "" : status.getMessage());
            }
        }

        @Override
        public ObjectProperty<Status> statusProperty() {
            return this.statusProperty;
        }

        @Override
        public void setStatus(Status status) {
            this.statusProperty().set((Object)status);
        }

        @Override
        public Status getStatus() {
            return (Status)this.statusProperty().get();
        }
    }

    public static enum Location {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

