/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import java.util.Hashtable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.core.util.DebugTraceUtil;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class MarketplaceClientUiPlugin
extends AbstractUIPlugin {
    public static final String IU_ICON_UPDATE = "IU_ICON_UPDATE";
    public static final String IU_ICON_INSTALL = "IU_ICON_INSTALL";
    public static final String IU_ICON_UNINSTALL = "IU_ICON_UNINSTALL";
    public static final String IU_ICON_DISABLED = "IU_ICON_DISABLED";
    public static final String IU_ICON = "IU_ICON";
    public static final String IU_ICON_ERROR = "IU_ICON_ERROR";
    public static final String NEWS_ICON_UPDATE = "NEWS_ICON_UPDATE";
    public static final String NO_ICON_PROVIDED = "NO_ICON_PROVIDED";
    public static final String NO_ICON_PROVIDED_CATALOG = "NO_ICON_PROVIDED_CATALOG";
    public static final String DEFAULT_MARKETPLACE_ICON = "DEFAULT_MARKETPLACE_ICON";
    public static final String ACTION_ICON_FAVORITES = "ACTION_ICON_FAVORITES";
    public static final String ACTION_ICON_LOGIN = "ACTION_ICON_LOGIN";
    public static final String ACTION_ICON_WARNING = "ACTION_ICON_WARNING";
    public static final String FAVORITES_LIST_ICON = "FAVORITES_LIST_ICON";
    public static final String ITEM_ICON_STAR = "ITEM_ICON_STAR";
    public static final String ITEM_ICON_STAR_SELECTED = "ITEM_ICON_STAR_SELECTED";
    public static final String ITEM_ICON_SHARE = "ITEM_ICON_SHARE";
    public static final String DEBUG_OPTION = "/debug";
    public static final String DROP_ADAPTER_DEBUG_OPTION = "/debug/dnd";
    private static MarketplaceClientUiPlugin instance;
    private static BundleContext bundleContext;
    public static boolean DEBUG;
    private static DebugTrace debugTrace;
    private ServiceTracker<IMarketplaceClientService, IMarketplaceClientService> clientServiceTracker;
    private ResourceProvider resourceProvider;

    static {
        DEBUG = false;
    }

    public void start(BundleContext context) throws Exception {
        instance = this;
        super.start(context);
        bundleContext = context;
        this.clientServiceTracker = new ServiceTracker(context, IMarketplaceClientService.class, null);
        this.clientServiceTracker.open();
        this.resourceProvider = new ResourceProvider();
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", "org.eclipse.epp.mpc.ui");
        context.registerService(DebugOptionsListener.class.getName(), (Object)new DebugOptionsListener(){

            public void optionsChanged(DebugOptions options) {
                DebugTrace debugTrace = null;
                boolean debug = options.getBooleanOption("org.eclipse.epp.mpc.ui/debug", false);
                if (debug) {
                    debugTrace = options.newDebugTrace("org.eclipse.epp.mpc.ui");
                }
                DEBUG = debug;
                MarketplaceClientUiPlugin.debugTrace = debugTrace;
            }
        }, props);
    }

    public void stop(BundleContext context) throws Exception {
        Job.getJobManager().cancel((Object)context.getBundle());
        this.clientServiceTracker.close();
        this.clientServiceTracker = null;
        if (this.resourceProvider != null) {
            this.resourceProvider.dispose();
            this.resourceProvider = null;
        }
        bundleContext = null;
        super.stop(context);
        debugTrace = null;
        instance = null;
    }

    public static MarketplaceClientUiPlugin getInstance() {
        return instance;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry imageRegistry = super.createImageRegistry();
        imageRegistry.put(NO_ICON_PROVIDED, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/noiconprovided.png"));
        imageRegistry.put(NO_ICON_PROVIDED_CATALOG, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/noiconprovided32.png"));
        imageRegistry.put(DEFAULT_MARKETPLACE_ICON, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/marketplace_banner.png"));
        imageRegistry.put(IU_ICON, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/iu_obj.gif"));
        imageRegistry.put(IU_ICON_UPDATE, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/iu_update_obj.gif"));
        imageRegistry.put(IU_ICON_INSTALL, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/iu_install_obj.gif"));
        imageRegistry.put(IU_ICON_UNINSTALL, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/iu_uninstall_obj.gif"));
        imageRegistry.put(IU_ICON_DISABLED, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/iu_disabled_obj.gif"));
        ImageDescriptor errorOverlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
        Image iuImage = imageRegistry.get(IU_ICON);
        DecorationOverlayIcon iuErrorIcon = new DecorationOverlayIcon(iuImage, errorOverlay, 3);
        imageRegistry.put(IU_ICON_ERROR, (ImageDescriptor)iuErrorIcon);
        imageRegistry.put(NEWS_ICON_UPDATE, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/news_update.gif"));
        imageRegistry.put(ITEM_ICON_STAR, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/star.png"));
        imageRegistry.put(ITEM_ICON_STAR_SELECTED, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/star-selected.png"));
        imageRegistry.put(ITEM_ICON_SHARE, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/share.png"));
        imageRegistry.put(ACTION_ICON_FAVORITES, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/action-item-favorites.png"));
        imageRegistry.put(ACTION_ICON_LOGIN, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/action-item-login.png"));
        imageRegistry.put(ACTION_ICON_WARNING, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/action-item-warning.png"));
        imageRegistry.put(FAVORITES_LIST_ICON, MarketplaceClientUiPlugin.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)"icons/favorites-list.png"));
        return imageRegistry;
    }

    public IMarketplaceClientService getClientService() {
        return this.clientServiceTracker == null ? null : (IMarketplaceClientService)this.clientServiceTracker.getService();
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void trace(String option, String message) {
        DebugTrace trace = debugTrace;
        if (DEBUG && trace != null) {
            trace.trace(option, message);
        }
    }

    public static void trace(String option, String message, Object ... parameters) {
        DebugTrace trace = debugTrace;
        if (DEBUG && trace != null) {
            DebugTraceUtil.trace((DebugTrace)trace, (String)option, (String)message, (Object[])parameters);
        }
    }

    static /* synthetic */ DebugTrace access$0() {
        return debugTrace;
    }
}

