/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.internal.ui.history.Branch;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Segment;
import org.eclipse.emf.cdo.internal.ui.history.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Commit {
    private final CDOCommitInfo commitInfo;
    private final Segment segment;
    private Segment[] rowSegments;
    private int commitCounter = -1;
    private Commit mergeSource;
    private List<Commit> mergeTargets;
    private Segment mergeSegment;

    public Commit(CDOCommitInfo commitInfo, Segment segment) {
        this.segment = segment;
        this.commitInfo = commitInfo;
        CDOCommitInfo mergedCommitInfo = commitInfo.getMergedCommitInfo();
        if (mergedCommitInfo != null) {
            Net net = this.getNet();
            this.mergeSource = net.getCommit(mergedCommitInfo);
            if (this.mergeSource != null) {
                this.mergeSource.addMergeTargets(Collections.singletonList(this));
            } else {
                net.addDanglingMergeTarget(mergedCommitInfo, this);
            }
        }
    }

    public CDOCommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    public Net getNet() {
        return this.segment.getNet();
    }

    public Track getTrack() {
        return this.segment.getTrack();
    }

    public Branch getBranch() {
        return this.segment.getBranch();
    }

    public long getTime() {
        return this.commitInfo.getTimeStamp();
    }

    public Commit getMergeSource() {
        return this.mergeSource;
    }

    public List<Commit> getMergeTargets() {
        return this.mergeTargets;
    }

    public Segment getMergeSegment() {
        return this.mergeSegment;
    }

    public final Segment getSegment() {
        return this.segment;
    }

    public final Segment[] getRowSegments() {
        Net net = this.segment.getNet();
        int netCommitCounter = net.getCommitCounter();
        if (this.rowSegments == null || this.commitCounter < netCommitCounter) {
            long time = this.getTime();
            this.rowSegments = net.createRowSegments(time);
            this.commitCounter = netCommitCounter;
        }
        return this.rowSegments;
    }

    public final boolean isFirstInBranch() {
        long firstTime = this.segment.getBranch().getFirstCommitTime();
        return this.getTime() == firstTime;
    }

    public final boolean isLastInBranch() {
        long lastTime = this.segment.getBranch().getLastCommitTime();
        return this.getTime() == lastTime;
    }

    public String toString() {
        return "Commit[" + this.getTime() + " --> " + this.segment + "]";
    }

    void setMergeSource(Commit mergeSource) {
        this.mergeSource = mergeSource;
    }

    void addMergeTargets(List<Commit> mergeTargets) {
        for (Commit mergeTarget : mergeTargets) {
            this.addMergeTargetToList(mergeTarget);
        }
        this.computeMergeSegment();
    }

    private void addMergeTargetToList(Commit mergeTarget) {
        if (this.mergeTargets == null) {
            this.mergeTargets = new ArrayList<Commit>(1);
        } else {
            ListIterator<Commit> it = this.mergeTargets.listIterator();
            while (it.hasNext()) {
                Commit commit = it.next();
                if (commit.getTime() <= mergeTarget.getTime()) continue;
                it.previous();
                it.add(mergeTarget);
                return;
            }
        }
        this.mergeTargets.add(mergeTarget);
    }

    private void computeMergeSegment() {
        if (this.mergeSegment != null) {
            this.mergeSegment.getTrack().removeSegment(this.mergeSegment);
            this.mergeSegment = null;
        }
        Commit lastMergeTarget = this.mergeTargets.get(this.mergeTargets.size() - 1);
        long lastMergeTime = lastMergeTarget.getTime();
        Net net = this.getNet();
        Track track = this.getTrack();
        Branch branch = this.getBranch();
        long commitTime = this.getTime();
        if (this.isLastInBranch() && !track.hasSegment(commitTime + 1L, lastMergeTime)) {
            this.mergeSegment = new Segment(track, branch, this);
            this.mergeSegment.adjustCommitTimes(commitTime + 1L);
            this.mergeSegment.adjustCommitTimes(lastMergeTime);
            track.addSegment(this.mergeSegment, true);
        } else {
            this.mergeSegment = net.createMergeSegment(this, lastMergeTime);
            this.mergeSegment.adjustCommitTimes(commitTime);
            this.mergeSegment.adjustCommitTimes(lastMergeTime);
        }
    }
}

